package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class DescribeConformancePackStatusResponse(
    conformancePackStatusDetails: Option[
      Iterable[zio.aws.config.model.ConformancePackStatusDetail]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse = {
    import DescribeConformancePackStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse
      .builder()
      .optionallyWith(
        conformancePackStatusDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conformancePackStatusDetails)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConformancePackStatusResponse.ReadOnly =
    zio.aws.config.model.DescribeConformancePackStatusResponse
      .wrap(buildAwsValue())
}
object DescribeConformancePackStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeConformancePackStatusResponse =
      zio.aws.config.model.DescribeConformancePackStatusResponse(
        conformancePackStatusDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def conformancePackStatusDetails: Option[
      List[zio.aws.config.model.ConformancePackStatusDetail.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getConformancePackStatusDetails: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConformancePackStatusDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "conformancePackStatusDetails",
      conformancePackStatusDetails
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse
  ) extends zio.aws.config.model.DescribeConformancePackStatusResponse.ReadOnly {
    override val conformancePackStatusDetails: Option[
      List[zio.aws.config.model.ConformancePackStatusDetail.ReadOnly]
    ] = scala
      .Option(impl.conformancePackStatusDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConformancePackStatusDetail.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse
  ): zio.aws.config.model.DescribeConformancePackStatusResponse.ReadOnly =
    new Wrapper(impl)
}
