package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  StringWithCharLimit64,
  StringWithCharLimit1024,
  StringWithCharLimit256,
  EmptiableStringWithCharLimit256,
  ConfigRuleName
}
import scala.jdk.CollectionConverters.*
final case class ConfigRule(
    configRuleName: Option[ConfigRuleName] = None,
    configRuleArn: Option[StringWithCharLimit256] = None,
    configRuleId: Option[StringWithCharLimit64] = None,
    description: Option[EmptiableStringWithCharLimit256] = None,
    scope: Option[zio.aws.config.model.Scope] = None,
    source: zio.aws.config.model.Source,
    inputParameters: Option[StringWithCharLimit1024] = None,
    maximumExecutionFrequency: Option[
      zio.aws.config.model.MaximumExecutionFrequency
    ] = None,
    configRuleState: Option[zio.aws.config.model.ConfigRuleState] = None,
    createdBy: Option[StringWithCharLimit256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigRule = {
    import ConfigRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigRule
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(
        configRuleArn.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.configRuleArn)
      .optionallyWith(
        configRuleId.map(value =>
          StringWithCharLimit64.unwrap(value): java.lang.String
        )
      )(_.configRuleId)
      .optionallyWith(
        description.map(value =>
          EmptiableStringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(scope.map(value => value.buildAwsValue()))(_.scope)
      .source(source.buildAwsValue())
      .optionallyWith(
        inputParameters.map(value =>
          StringWithCharLimit1024.unwrap(value): java.lang.String
        )
      )(_.inputParameters)
      .optionallyWith(maximumExecutionFrequency.map(value => value.unwrap))(
        _.maximumExecutionFrequency
      )
      .optionallyWith(configRuleState.map(value => value.unwrap))(
        _.configRuleState
      )
      .optionallyWith(
        createdBy.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.createdBy)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigRule.ReadOnly =
    zio.aws.config.model.ConfigRule.wrap(buildAwsValue())
}
object ConfigRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.ConfigRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigRule =
      zio.aws.config.model.ConfigRule(
        configRuleName.map(value => value),
        configRuleArn.map(value => value),
        configRuleId.map(value => value),
        description.map(value => value),
        scope.map(value => value.asEditable),
        source.asEditable,
        inputParameters.map(value => value),
        maximumExecutionFrequency.map(value => value),
        configRuleState.map(value => value),
        createdBy.map(value => value)
      )
    def configRuleName: Option[ConfigRuleName]
    def configRuleArn: Option[StringWithCharLimit256]
    def configRuleId: Option[StringWithCharLimit64]
    def description: Option[EmptiableStringWithCharLimit256]
    def scope: Option[zio.aws.config.model.Scope.ReadOnly]
    def source: zio.aws.config.model.Source.ReadOnly
    def inputParameters: Option[StringWithCharLimit1024]
    def maximumExecutionFrequency
        : Option[zio.aws.config.model.MaximumExecutionFrequency]
    def configRuleState: Option[zio.aws.config.model.ConfigRuleState]
    def createdBy: Option[StringWithCharLimit256]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getConfigRuleArn: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("configRuleArn", configRuleArn)
    def getConfigRuleId: ZIO[Any, AwsError, StringWithCharLimit64] =
      AwsError.unwrapOptionField("configRuleId", configRuleId)
    def getDescription: ZIO[Any, AwsError, EmptiableStringWithCharLimit256] =
      AwsError.unwrapOptionField("description", description)
    def getScope: ZIO[Any, AwsError, zio.aws.config.model.Scope.ReadOnly] =
      AwsError.unwrapOptionField("scope", scope)
    def getSource: ZIO[Any, Nothing, zio.aws.config.model.Source.ReadOnly] =
      ZIO.succeed(source)
    def getInputParameters: ZIO[Any, AwsError, StringWithCharLimit1024] =
      AwsError.unwrapOptionField("inputParameters", inputParameters)
    def getMaximumExecutionFrequency
        : ZIO[Any, AwsError, zio.aws.config.model.MaximumExecutionFrequency] =
      AwsError.unwrapOptionField(
        "maximumExecutionFrequency",
        maximumExecutionFrequency
      )
    def getConfigRuleState
        : ZIO[Any, AwsError, zio.aws.config.model.ConfigRuleState] =
      AwsError.unwrapOptionField("configRuleState", configRuleState)
    def getCreatedBy: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigRule
  ) extends zio.aws.config.model.ConfigRule.ReadOnly {
    override val configRuleName: Option[ConfigRuleName] = scala
      .Option(impl.configRuleName())
      .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val configRuleArn: Option[StringWithCharLimit256] = scala
      .Option(impl.configRuleArn())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val configRuleId: Option[StringWithCharLimit64] = scala
      .Option(impl.configRuleId())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit64(value)
      )
    override val description: Option[EmptiableStringWithCharLimit256] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.config.model.primitives.EmptiableStringWithCharLimit256(value)
      )
    override val scope: Option[zio.aws.config.model.Scope.ReadOnly] = scala
      .Option(impl.scope())
      .map(value => zio.aws.config.model.Scope.wrap(value))
    override val source: zio.aws.config.model.Source.ReadOnly =
      zio.aws.config.model.Source.wrap(impl.source())
    override val inputParameters: Option[StringWithCharLimit1024] = scala
      .Option(impl.inputParameters())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit1024(value)
      )
    override val maximumExecutionFrequency
        : Option[zio.aws.config.model.MaximumExecutionFrequency] = scala
      .Option(impl.maximumExecutionFrequency())
      .map(value => zio.aws.config.model.MaximumExecutionFrequency.wrap(value))
    override val configRuleState: Option[zio.aws.config.model.ConfigRuleState] =
      scala
        .Option(impl.configRuleState())
        .map(value => zio.aws.config.model.ConfigRuleState.wrap(value))
    override val createdBy: Option[StringWithCharLimit256] = scala
      .Option(impl.createdBy())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigRule
  ): zio.aws.config.model.ConfigRule.ReadOnly = new Wrapper(impl)
}
