package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  QueryDescription,
  QueryName,
  QueryArn,
  QueryId
}
import scala.jdk.CollectionConverters.*
final case class StoredQueryMetadata(
    queryId: QueryId,
    queryArn: QueryArn,
    queryName: QueryName,
    description: Option[QueryDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StoredQueryMetadata = {
    import StoredQueryMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StoredQueryMetadata
      .builder()
      .queryId(QueryId.unwrap(queryId): java.lang.String)
      .queryArn(QueryArn.unwrap(queryArn): java.lang.String)
      .queryName(QueryName.unwrap(queryName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          QueryDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.config.model.StoredQueryMetadata.ReadOnly =
    zio.aws.config.model.StoredQueryMetadata.wrap(buildAwsValue())
}
object StoredQueryMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StoredQueryMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StoredQueryMetadata =
      zio.aws.config.model.StoredQueryMetadata(
        queryId,
        queryArn,
        queryName,
        description.map(value => value)
      )
    def queryId: QueryId
    def queryArn: QueryArn
    def queryName: QueryName
    def description: Option[QueryDescription]
    def getQueryId: ZIO[Any, Nothing, QueryId] = ZIO.succeed(queryId)
    def getQueryArn: ZIO[Any, Nothing, QueryArn] = ZIO.succeed(queryArn)
    def getQueryName: ZIO[Any, Nothing, QueryName] = ZIO.succeed(queryName)
    def getDescription: ZIO[Any, AwsError, QueryDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StoredQueryMetadata
  ) extends zio.aws.config.model.StoredQueryMetadata.ReadOnly {
    override val queryId: QueryId =
      zio.aws.config.model.primitives.QueryId(impl.queryId())
    override val queryArn: QueryArn =
      zio.aws.config.model.primitives.QueryArn(impl.queryArn())
    override val queryName: QueryName =
      zio.aws.config.model.primitives.QueryName(impl.queryName())
    override val description: Option[QueryDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.config.model.primitives.QueryDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StoredQueryMetadata
  ): zio.aws.config.model.StoredQueryMetadata.ReadOnly = new Wrapper(impl)
}
