package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.{
  RetentionPeriodInDays,
  RetentionConfigurationName
}
import scala.jdk.CollectionConverters.*
final case class RetentionConfiguration(
    name: RetentionConfigurationName,
    retentionPeriodInDays: RetentionPeriodInDays
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RetentionConfiguration = {
    import RetentionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RetentionConfiguration
      .builder()
      .name(RetentionConfigurationName.unwrap(name): java.lang.String)
      .retentionPeriodInDays(
        RetentionPeriodInDays.unwrap(retentionPeriodInDays): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.RetentionConfiguration.ReadOnly =
    zio.aws.config.model.RetentionConfiguration.wrap(buildAwsValue())
}
object RetentionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RetentionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RetentionConfiguration =
      zio.aws.config.model.RetentionConfiguration(name, retentionPeriodInDays)
    def name: RetentionConfigurationName
    def retentionPeriodInDays: RetentionPeriodInDays
    def getName: ZIO[Any, Nothing, RetentionConfigurationName] =
      ZIO.succeed(name)
    def getRetentionPeriodInDays: ZIO[Any, Nothing, RetentionPeriodInDays] =
      ZIO.succeed(retentionPeriodInDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RetentionConfiguration
  ) extends zio.aws.config.model.RetentionConfiguration.ReadOnly {
    override val name: RetentionConfigurationName =
      zio.aws.config.model.primitives.RetentionConfigurationName(impl.name())
    override val retentionPeriodInDays: RetentionPeriodInDays =
      zio.aws.config.model.primitives
        .RetentionPeriodInDays(impl.retentionPeriodInDays())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RetentionConfiguration
  ): zio.aws.config.model.RetentionConfiguration.ReadOnly = new Wrapper(impl)
}
