package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.Date
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RemediationExecutionStep(
    name: Option[String] = None,
    state: Option[zio.aws.config.model.RemediationExecutionStepState] = None,
    errorMessage: Option[String] = None,
    startTime: Option[Date] = None,
    stopTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RemediationExecutionStep = {
    import RemediationExecutionStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RemediationExecutionStep
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(startTime.map(value => Date.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(stopTime.map(value => Date.unwrap(value): Instant))(
        _.stopTime
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.RemediationExecutionStep.ReadOnly =
    zio.aws.config.model.RemediationExecutionStep.wrap(buildAwsValue())
}
object RemediationExecutionStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RemediationExecutionStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RemediationExecutionStep =
      zio.aws.config.model.RemediationExecutionStep(
        name.map(value => value),
        state.map(value => value),
        errorMessage.map(value => value),
        startTime.map(value => value),
        stopTime.map(value => value)
      )
    def name: Option[String]
    def state: Option[zio.aws.config.model.RemediationExecutionStepState]
    def errorMessage: Option[String]
    def startTime: Option[Date]
    def stopTime: Option[Date]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.RemediationExecutionStepState
    ] = AwsError.unwrapOptionField("state", state)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStopTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("stopTime", stopTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RemediationExecutionStep
  ) extends zio.aws.config.model.RemediationExecutionStep.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val state
        : Option[zio.aws.config.model.RemediationExecutionStepState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.config.model.RemediationExecutionStepState.wrap(value)
      )
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
    override val startTime: Option[Date] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val stopTime: Option[Date] = scala
      .Option(impl.stopTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RemediationExecutionStep
  ): zio.aws.config.model.RemediationExecutionStep.ReadOnly = new Wrapper(impl)
}
