package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  StringWithCharLimit2048,
  StringWithCharLimit256,
  StringWithCharLimit128,
  StringWithCharLimit768,
  StringWithCharLimit256Min0
}
import scala.jdk.CollectionConverters.*
final case class OrganizationCustomRuleMetadata(
    description: Option[StringWithCharLimit256Min0] = None,
    lambdaFunctionArn: StringWithCharLimit256,
    organizationConfigRuleTriggerTypes: Iterable[
      zio.aws.config.model.OrganizationConfigRuleTriggerType
    ],
    inputParameters: Option[StringWithCharLimit2048] = None,
    maximumExecutionFrequency: Option[
      zio.aws.config.model.MaximumExecutionFrequency
    ] = None,
    resourceTypesScope: Option[Iterable[StringWithCharLimit256]] = None,
    resourceIdScope: Option[StringWithCharLimit768] = None,
    tagKeyScope: Option[StringWithCharLimit128] = None,
    tagValueScope: Option[StringWithCharLimit256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.OrganizationCustomRuleMetadata = {
    import OrganizationCustomRuleMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.OrganizationCustomRuleMetadata
      .builder()
      .optionallyWith(
        description.map(value =>
          StringWithCharLimit256Min0.unwrap(value): java.lang.String
        )
      )(_.description)
      .lambdaFunctionArn(
        StringWithCharLimit256.unwrap(lambdaFunctionArn): java.lang.String
      )
      .organizationConfigRuleTriggerTypesWithStrings(
        organizationConfigRuleTriggerTypes.map { item =>
          item.unwrap.toString
        }.asJavaCollection
      )
      .optionallyWith(
        inputParameters.map(value =>
          StringWithCharLimit2048.unwrap(value): java.lang.String
        )
      )(_.inputParameters)
      .optionallyWith(maximumExecutionFrequency.map(value => value.unwrap))(
        _.maximumExecutionFrequency
      )
      .optionallyWith(
        resourceTypesScope.map(value =>
          value.map { item =>
            StringWithCharLimit256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypesScope)
      .optionallyWith(
        resourceIdScope.map(value =>
          StringWithCharLimit768.unwrap(value): java.lang.String
        )
      )(_.resourceIdScope)
      .optionallyWith(
        tagKeyScope.map(value =>
          StringWithCharLimit128.unwrap(value): java.lang.String
        )
      )(_.tagKeyScope)
      .optionallyWith(
        tagValueScope.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.tagValueScope)
      .build()
  }
  def asReadOnly: zio.aws.config.model.OrganizationCustomRuleMetadata.ReadOnly =
    zio.aws.config.model.OrganizationCustomRuleMetadata.wrap(buildAwsValue())
}
object OrganizationCustomRuleMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.OrganizationCustomRuleMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.OrganizationCustomRuleMetadata =
      zio.aws.config.model.OrganizationCustomRuleMetadata(
        description.map(value => value),
        lambdaFunctionArn,
        organizationConfigRuleTriggerTypes,
        inputParameters.map(value => value),
        maximumExecutionFrequency.map(value => value),
        resourceTypesScope.map(value => value),
        resourceIdScope.map(value => value),
        tagKeyScope.map(value => value),
        tagValueScope.map(value => value)
      )
    def description: Option[StringWithCharLimit256Min0]
    def lambdaFunctionArn: StringWithCharLimit256
    def organizationConfigRuleTriggerTypes
        : List[zio.aws.config.model.OrganizationConfigRuleTriggerType]
    def inputParameters: Option[StringWithCharLimit2048]
    def maximumExecutionFrequency
        : Option[zio.aws.config.model.MaximumExecutionFrequency]
    def resourceTypesScope: Option[List[StringWithCharLimit256]]
    def resourceIdScope: Option[StringWithCharLimit768]
    def tagKeyScope: Option[StringWithCharLimit128]
    def tagValueScope: Option[StringWithCharLimit256]
    def getDescription: ZIO[Any, AwsError, StringWithCharLimit256Min0] =
      AwsError.unwrapOptionField("description", description)
    def getLambdaFunctionArn: ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(lambdaFunctionArn)
    def getOrganizationConfigRuleTriggerTypes: ZIO[Any, Nothing, List[
      zio.aws.config.model.OrganizationConfigRuleTriggerType
    ]] = ZIO.succeed(organizationConfigRuleTriggerTypes)
    def getInputParameters: ZIO[Any, AwsError, StringWithCharLimit2048] =
      AwsError.unwrapOptionField("inputParameters", inputParameters)
    def getMaximumExecutionFrequency
        : ZIO[Any, AwsError, zio.aws.config.model.MaximumExecutionFrequency] =
      AwsError.unwrapOptionField(
        "maximumExecutionFrequency",
        maximumExecutionFrequency
      )
    def getResourceTypesScope
        : ZIO[Any, AwsError, List[StringWithCharLimit256]] =
      AwsError.unwrapOptionField("resourceTypesScope", resourceTypesScope)
    def getResourceIdScope: ZIO[Any, AwsError, StringWithCharLimit768] =
      AwsError.unwrapOptionField("resourceIdScope", resourceIdScope)
    def getTagKeyScope: ZIO[Any, AwsError, StringWithCharLimit128] =
      AwsError.unwrapOptionField("tagKeyScope", tagKeyScope)
    def getTagValueScope: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("tagValueScope", tagValueScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.OrganizationCustomRuleMetadata
  ) extends zio.aws.config.model.OrganizationCustomRuleMetadata.ReadOnly {
    override val description: Option[StringWithCharLimit256Min0] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256Min0(value)
      )
    override val lambdaFunctionArn: StringWithCharLimit256 =
      zio.aws.config.model.primitives
        .StringWithCharLimit256(impl.lambdaFunctionArn())
    override val organizationConfigRuleTriggerTypes
        : List[zio.aws.config.model.OrganizationConfigRuleTriggerType] = impl
      .organizationConfigRuleTriggerTypes()
      .asScala
      .map { item =>
        zio.aws.config.model.OrganizationConfigRuleTriggerType.wrap(item)
      }
      .toList
    override val inputParameters: Option[StringWithCharLimit2048] = scala
      .Option(impl.inputParameters())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit2048(value)
      )
    override val maximumExecutionFrequency
        : Option[zio.aws.config.model.MaximumExecutionFrequency] = scala
      .Option(impl.maximumExecutionFrequency())
      .map(value => zio.aws.config.model.MaximumExecutionFrequency.wrap(value))
    override val resourceTypesScope: Option[List[StringWithCharLimit256]] =
      scala
        .Option(impl.resourceTypesScope())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.StringWithCharLimit256(item)
          }.toList
        )
    override val resourceIdScope: Option[StringWithCharLimit768] = scala
      .Option(impl.resourceIdScope())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit768(value)
      )
    override val tagKeyScope: Option[StringWithCharLimit128] = scala
      .Option(impl.tagKeyScope())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit128(value)
      )
    override val tagValueScope: Option[StringWithCharLimit256] = scala
      .Option(impl.tagValueScope())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.OrganizationCustomRuleMetadata
  ): zio.aws.config.model.OrganizationCustomRuleMetadata.ReadOnly = new Wrapper(
    impl
  )
}
