package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{Date, OrganizationConformancePackName}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OrganizationConformancePackStatus(
    organizationConformancePackName: OrganizationConformancePackName,
    status: zio.aws.config.model.OrganizationResourceStatus,
    errorCode: Option[String] = None,
    errorMessage: Option[String] = None,
    lastUpdateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.OrganizationConformancePackStatus = {
    import OrganizationConformancePackStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.OrganizationConformancePackStatus
      .builder()
      .organizationConformancePackName(
        OrganizationConformancePackName.unwrap(
          organizationConformancePackName
        ): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(lastUpdateTime.map(value => Date.unwrap(value): Instant))(
        _.lastUpdateTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly =
    zio.aws.config.model.OrganizationConformancePackStatus.wrap(buildAwsValue())
}
object OrganizationConformancePackStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.OrganizationConformancePackStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.OrganizationConformancePackStatus =
      zio.aws.config.model.OrganizationConformancePackStatus(
        organizationConformancePackName,
        status,
        errorCode.map(value => value),
        errorMessage.map(value => value),
        lastUpdateTime.map(value => value)
      )
    def organizationConformancePackName: OrganizationConformancePackName
    def status: zio.aws.config.model.OrganizationResourceStatus
    def errorCode: Option[String]
    def errorMessage: Option[String]
    def lastUpdateTime: Option[Date]
    def getOrganizationConformancePackName
        : ZIO[Any, Nothing, OrganizationConformancePackName] =
      ZIO.succeed(organizationConformancePackName)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.config.model.OrganizationResourceStatus] =
      ZIO.succeed(status)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getLastUpdateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.OrganizationConformancePackStatus
  ) extends zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly {
    override val organizationConformancePackName
        : OrganizationConformancePackName = zio.aws.config.model.primitives
      .OrganizationConformancePackName(impl.organizationConformancePackName())
    override val status: zio.aws.config.model.OrganizationResourceStatus =
      zio.aws.config.model.OrganizationResourceStatus.wrap(impl.status())
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
    override val lastUpdateTime: Option[Date] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.OrganizationConformancePackStatus
  ): zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly =
    new Wrapper(impl)
}
