package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.Limit
import scala.jdk.CollectionConverters.*
final case class ListStoredQueriesRequest(
    nextToken: Option[String] = None,
    maxResults: Option[Limit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListStoredQueriesRequest = {
    import ListStoredQueriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListStoredQueriesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ListStoredQueriesRequest.ReadOnly =
    zio.aws.config.model.ListStoredQueriesRequest.wrap(buildAwsValue())
}
object ListStoredQueriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListStoredQueriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ListStoredQueriesRequest =
      zio.aws.config.model.ListStoredQueriesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[String]
    def maxResults: Option[Limit]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListStoredQueriesRequest
  ) extends zio.aws.config.model.ListStoredQueriesRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[Limit] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.config.model.primitives.Limit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListStoredQueriesRequest
  ): zio.aws.config.model.ListStoredQueriesRequest.ReadOnly = new Wrapper(impl)
}
