package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  NextToken,
  Limit,
  ConfigurationAggregatorName
}
import scala.jdk.CollectionConverters.*
final case class ListAggregateDiscoveredResourcesRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    resourceType: zio.aws.config.model.ResourceType,
    filters: Option[zio.aws.config.model.ResourceFilters] = None,
    limit: Option[Limit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest = {
    import ListAggregateDiscoveredResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .resourceType(resourceType.unwrap)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ListAggregateDiscoveredResourcesRequest.ReadOnly =
    zio.aws.config.model.ListAggregateDiscoveredResourcesRequest
      .wrap(buildAwsValue())
}
object ListAggregateDiscoveredResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.ListAggregateDiscoveredResourcesRequest =
      zio.aws.config.model.ListAggregateDiscoveredResourcesRequest(
        configurationAggregatorName,
        resourceType,
        filters.map(value => value.asEditable),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def resourceType: zio.aws.config.model.ResourceType
    def filters: Option[zio.aws.config.model.ResourceFilters.ReadOnly]
    def limit: Option[Limit]
    def nextToken: Option[NextToken]
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getResourceType: ZIO[Any, Nothing, zio.aws.config.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getFilters
        : ZIO[Any, AwsError, zio.aws.config.model.ResourceFilters.ReadOnly] =
      AwsError.unwrapOptionField("filters", filters)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest
  ) extends zio.aws.config.model.ListAggregateDiscoveredResourcesRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val resourceType: zio.aws.config.model.ResourceType =
      zio.aws.config.model.ResourceType.wrap(impl.resourceType())
    override val filters
        : Option[zio.aws.config.model.ResourceFilters.ReadOnly] = scala
      .Option(impl.filters())
      .map(value => zio.aws.config.model.ResourceFilters.wrap(value))
    override val limit: Option[Limit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest
  ): zio.aws.config.model.ListAggregateDiscoveredResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
