package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeRemediationExecutionStatusResponse(
    remediationExecutionStatuses: Option[
      Iterable[zio.aws.config.model.RemediationExecutionStatus]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse = {
    import DescribeRemediationExecutionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse
      .builder()
      .optionallyWith(
        remediationExecutionStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.remediationExecutionStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly =
    zio.aws.config.model.DescribeRemediationExecutionStatusResponse
      .wrap(buildAwsValue())
}
object DescribeRemediationExecutionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeRemediationExecutionStatusResponse =
      zio.aws.config.model.DescribeRemediationExecutionStatusResponse(
        remediationExecutionStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def remediationExecutionStatuses
        : Option[List[zio.aws.config.model.RemediationExecutionStatus.ReadOnly]]
    def nextToken: Option[String]
    def getRemediationExecutionStatuses: ZIO[Any, AwsError, List[
      zio.aws.config.model.RemediationExecutionStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "remediationExecutionStatuses",
      remediationExecutionStatuses
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse
  ) extends zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly {
    override val remediationExecutionStatuses: Option[
      List[zio.aws.config.model.RemediationExecutionStatus.ReadOnly]
    ] = scala
      .Option(impl.remediationExecutionStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.RemediationExecutionStatus.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse
  ): zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
