package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeConfigRuleEvaluationStatusResponse(
    configRulesEvaluationStatus: Option[
      Iterable[zio.aws.config.model.ConfigRuleEvaluationStatus]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse = {
    import DescribeConfigRuleEvaluationStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse
      .builder()
      .optionallyWith(
        configRulesEvaluationStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configRulesEvaluationStatus)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly =
    zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse
      .wrap(buildAwsValue())
}
object DescribeConfigRuleEvaluationStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse =
      zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse(
        configRulesEvaluationStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configRulesEvaluationStatus
        : Option[List[zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly]]
    def nextToken: Option[String]
    def getConfigRulesEvaluationStatus: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "configRulesEvaluationStatus",
      configRulesEvaluationStatus
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse
  ) extends zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly {
    override val configRulesEvaluationStatus: Option[
      List[zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly]
    ] = scala
      .Option(impl.configRulesEvaluationStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConfigRuleEvaluationStatus.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse
  ): zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly =
    new Wrapper(impl)
}
