package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class DescribeAggregateComplianceByConformancePacksResponse(
    aggregateComplianceByConformancePacks: Option[
      Iterable[zio.aws.config.model.AggregateComplianceByConformancePack]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse = {
    import DescribeAggregateComplianceByConformancePacksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse
      .builder()
      .optionallyWith(
        aggregateComplianceByConformancePacks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregateComplianceByConformancePacks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse.ReadOnly =
    zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse
      .wrap(buildAwsValue())
}
object DescribeAggregateComplianceByConformancePacksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse =
      zio.aws.config.model
        .DescribeAggregateComplianceByConformancePacksResponse(
          aggregateComplianceByConformancePacks.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def aggregateComplianceByConformancePacks: Option[
      List[zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getAggregateComplianceByConformancePacks: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "aggregateComplianceByConformancePacks",
      aggregateComplianceByConformancePacks
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse
  ) extends zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse.ReadOnly {
    override val aggregateComplianceByConformancePacks: Option[
      List[zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly]
    ] = scala
      .Option(impl.aggregateComplianceByConformancePacks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.AggregateComplianceByConformancePack.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse
  ): zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse.ReadOnly =
    new Wrapper(impl)
}
