package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ConfigRuleState {
  def unwrap: software.amazon.awssdk.services.config.model.ConfigRuleState
}
object ConfigRuleState {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ConfigRuleState
  ): zio.aws.config.model.ConfigRuleState = value match {
    case software.amazon.awssdk.services.config.model.ConfigRuleState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ConfigRuleState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.config.model.ConfigRuleState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.config.model.ConfigRuleState.DELETING_RESULTS =>
      val r = DELETING_RESULTS
      r
    case software.amazon.awssdk.services.config.model.ConfigRuleState.EVALUATING =>
      val r = EVALUATING
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.ConfigRuleState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigRuleState =
      software.amazon.awssdk.services.config.model.ConfigRuleState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.config.model.ConfigRuleState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigRuleState =
      software.amazon.awssdk.services.config.model.ConfigRuleState.ACTIVE
  }
  case object DELETING extends zio.aws.config.model.ConfigRuleState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigRuleState =
      software.amazon.awssdk.services.config.model.ConfigRuleState.DELETING
  }
  case object DELETING_RESULTS extends zio.aws.config.model.ConfigRuleState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigRuleState =
      software.amazon.awssdk.services.config.model.ConfigRuleState.DELETING_RESULTS
  }
  case object EVALUATING extends zio.aws.config.model.ConfigRuleState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigRuleState =
      software.amazon.awssdk.services.config.model.ConfigRuleState.EVALUATING
  }
}
