package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{Date, ConfigRuleName}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ConfigRuleEvaluationStatus(
    configRuleName: Option[ConfigRuleName] = None,
    configRuleArn: Option[String] = None,
    configRuleId: Option[String] = None,
    lastSuccessfulInvocationTime: Option[Date] = None,
    lastFailedInvocationTime: Option[Date] = None,
    lastSuccessfulEvaluationTime: Option[Date] = None,
    lastFailedEvaluationTime: Option[Date] = None,
    firstActivatedTime: Option[Date] = None,
    lastDeactivatedTime: Option[Date] = None,
    lastErrorCode: Option[String] = None,
    lastErrorMessage: Option[String] = None,
    firstEvaluationStarted: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus = {
    import ConfigRuleEvaluationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(configRuleArn.map(value => value: java.lang.String))(
        _.configRuleArn
      )
      .optionallyWith(configRuleId.map(value => value: java.lang.String))(
        _.configRuleId
      )
      .optionallyWith(
        lastSuccessfulInvocationTime.map(value => Date.unwrap(value): Instant)
      )(_.lastSuccessfulInvocationTime)
      .optionallyWith(
        lastFailedInvocationTime.map(value => Date.unwrap(value): Instant)
      )(_.lastFailedInvocationTime)
      .optionallyWith(
        lastSuccessfulEvaluationTime.map(value => Date.unwrap(value): Instant)
      )(_.lastSuccessfulEvaluationTime)
      .optionallyWith(
        lastFailedEvaluationTime.map(value => Date.unwrap(value): Instant)
      )(_.lastFailedEvaluationTime)
      .optionallyWith(
        firstActivatedTime.map(value => Date.unwrap(value): Instant)
      )(_.firstActivatedTime)
      .optionallyWith(
        lastDeactivatedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastDeactivatedTime)
      .optionallyWith(lastErrorCode.map(value => value: java.lang.String))(
        _.lastErrorCode
      )
      .optionallyWith(lastErrorMessage.map(value => value: java.lang.String))(
        _.lastErrorMessage
      )
      .optionallyWith(
        firstEvaluationStarted.map(value => value: java.lang.Boolean)
      )(_.firstEvaluationStarted)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly =
    zio.aws.config.model.ConfigRuleEvaluationStatus.wrap(buildAwsValue())
}
object ConfigRuleEvaluationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigRuleEvaluationStatus =
      zio.aws.config.model.ConfigRuleEvaluationStatus(
        configRuleName.map(value => value),
        configRuleArn.map(value => value),
        configRuleId.map(value => value),
        lastSuccessfulInvocationTime.map(value => value),
        lastFailedInvocationTime.map(value => value),
        lastSuccessfulEvaluationTime.map(value => value),
        lastFailedEvaluationTime.map(value => value),
        firstActivatedTime.map(value => value),
        lastDeactivatedTime.map(value => value),
        lastErrorCode.map(value => value),
        lastErrorMessage.map(value => value),
        firstEvaluationStarted.map(value => value)
      )
    def configRuleName: Option[ConfigRuleName]
    def configRuleArn: Option[String]
    def configRuleId: Option[String]
    def lastSuccessfulInvocationTime: Option[Date]
    def lastFailedInvocationTime: Option[Date]
    def lastSuccessfulEvaluationTime: Option[Date]
    def lastFailedEvaluationTime: Option[Date]
    def firstActivatedTime: Option[Date]
    def lastDeactivatedTime: Option[Date]
    def lastErrorCode: Option[String]
    def lastErrorMessage: Option[String]
    def firstEvaluationStarted: Option[Boolean]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getConfigRuleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configRuleArn", configRuleArn)
    def getConfigRuleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configRuleId", configRuleId)
    def getLastSuccessfulInvocationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "lastSuccessfulInvocationTime",
        lastSuccessfulInvocationTime
      )
    def getLastFailedInvocationTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("lastFailedInvocationTime", lastFailedInvocationTime)
    def getLastSuccessfulEvaluationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "lastSuccessfulEvaluationTime",
        lastSuccessfulEvaluationTime
      )
    def getLastFailedEvaluationTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("lastFailedEvaluationTime", lastFailedEvaluationTime)
    def getFirstActivatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("firstActivatedTime", firstActivatedTime)
    def getLastDeactivatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastDeactivatedTime", lastDeactivatedTime)
    def getLastErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorCode", lastErrorCode)
    def getLastErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorMessage", lastErrorMessage)
    def getFirstEvaluationStarted: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("firstEvaluationStarted", firstEvaluationStarted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus
  ) extends zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly {
    override val configRuleName: Option[ConfigRuleName] = scala
      .Option(impl.configRuleName())
      .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val configRuleArn: Option[String] =
      scala.Option(impl.configRuleArn()).map(value => value: String)
    override val configRuleId: Option[String] =
      scala.Option(impl.configRuleId()).map(value => value: String)
    override val lastSuccessfulInvocationTime: Option[Date] = scala
      .Option(impl.lastSuccessfulInvocationTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastFailedInvocationTime: Option[Date] = scala
      .Option(impl.lastFailedInvocationTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastSuccessfulEvaluationTime: Option[Date] = scala
      .Option(impl.lastSuccessfulEvaluationTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastFailedEvaluationTime: Option[Date] = scala
      .Option(impl.lastFailedEvaluationTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val firstActivatedTime: Option[Date] = scala
      .Option(impl.firstActivatedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastDeactivatedTime: Option[Date] = scala
      .Option(impl.lastDeactivatedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastErrorCode: Option[String] =
      scala.Option(impl.lastErrorCode()).map(value => value: String)
    override val lastErrorMessage: Option[String] =
      scala.Option(impl.lastErrorMessage()).map(value => value: String)
    override val firstEvaluationStarted: Option[Boolean] =
      scala.Option(impl.firstEvaluationStarted()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus
  ): zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly = new Wrapper(
    impl
  )
}
