package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit256
import scala.jdk.CollectionConverters.*
final case class ComplianceSummaryByResourceType(
    resourceType: Option[StringWithCharLimit256] = None,
    complianceSummary: Option[zio.aws.config.model.ComplianceSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ComplianceSummaryByResourceType = {
    import ComplianceSummaryByResourceType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ComplianceSummaryByResourceType
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(complianceSummary.map(value => value.buildAwsValue()))(
        _.complianceSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ComplianceSummaryByResourceType.ReadOnly =
    zio.aws.config.model.ComplianceSummaryByResourceType.wrap(buildAwsValue())
}
object ComplianceSummaryByResourceType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ComplianceSummaryByResourceType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ComplianceSummaryByResourceType =
      zio.aws.config.model.ComplianceSummaryByResourceType(
        resourceType.map(value => value),
        complianceSummary.map(value => value.asEditable)
      )
    def resourceType: Option[StringWithCharLimit256]
    def complianceSummary
        : Option[zio.aws.config.model.ComplianceSummary.ReadOnly]
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getComplianceSummary
        : ZIO[Any, AwsError, zio.aws.config.model.ComplianceSummary.ReadOnly] =
      AwsError.unwrapOptionField("complianceSummary", complianceSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ComplianceSummaryByResourceType
  ) extends zio.aws.config.model.ComplianceSummaryByResourceType.ReadOnly {
    override val resourceType: Option[StringWithCharLimit256] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val complianceSummary
        : Option[zio.aws.config.model.ComplianceSummary.ReadOnly] = scala
      .Option(impl.complianceSummary())
      .map(value => zio.aws.config.model.ComplianceSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ComplianceSummaryByResourceType
  ): zio.aws.config.model.ComplianceSummaryByResourceType.ReadOnly =
    new Wrapper(impl)
}
