package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutRemediationConfigurationsResponse(
    failedBatches: Option[
      Iterable[zio.aws.config.model.FailedRemediationBatch]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse = {
    import PutRemediationConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse
      .builder()
      .optionallyWith(
        failedBatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedBatches)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutRemediationConfigurationsResponse.ReadOnly =
    zio.aws.config.model.PutRemediationConfigurationsResponse
      .wrap(buildAwsValue())
}
object PutRemediationConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutRemediationConfigurationsResponse =
      zio.aws.config.model.PutRemediationConfigurationsResponse(
        failedBatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedBatches
        : Option[List[zio.aws.config.model.FailedRemediationBatch.ReadOnly]]
    def getFailedBatches: ZIO[Any, AwsError, List[
      zio.aws.config.model.FailedRemediationBatch.ReadOnly
    ]] = AwsError.unwrapOptionField("failedBatches", failedBatches)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse
  ) extends zio.aws.config.model.PutRemediationConfigurationsResponse.ReadOnly {
    override val failedBatches
        : Option[List[zio.aws.config.model.FailedRemediationBatch.ReadOnly]] =
      scala
        .Option(impl.failedBatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.FailedRemediationBatch.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse
  ): zio.aws.config.model.PutRemediationConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
