package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit256
import scala.jdk.CollectionConverters.*
final case class PutOrganizationConformancePackResponse(
    organizationConformancePackArn: Option[StringWithCharLimit256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse = {
    import PutOrganizationConformancePackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse
      .builder()
      .optionallyWith(
        organizationConformancePackArn.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.organizationConformancePackArn)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutOrganizationConformancePackResponse.ReadOnly =
    zio.aws.config.model.PutOrganizationConformancePackResponse
      .wrap(buildAwsValue())
}
object PutOrganizationConformancePackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.PutOrganizationConformancePackResponse =
      zio.aws.config.model.PutOrganizationConformancePackResponse(
        organizationConformancePackArn.map(value => value)
      )
    def organizationConformancePackArn: Option[StringWithCharLimit256]
    def getOrganizationConformancePackArn
        : ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField(
        "organizationConformancePackArn",
        organizationConformancePackArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse
  ) extends zio.aws.config.model.PutOrganizationConformancePackResponse.ReadOnly {
    override val organizationConformancePackArn
        : Option[StringWithCharLimit256] = scala
      .Option(impl.organizationConformancePackArn())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse
  ): zio.aws.config.model.PutOrganizationConformancePackResponse.ReadOnly =
    new Wrapper(impl)
}
