package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{BaseResourceId, StringWithCharLimit256}
import scala.jdk.CollectionConverters.*
final case class GetComplianceDetailsByResourceRequest(
    resourceType: StringWithCharLimit256,
    resourceId: BaseResourceId,
    complianceTypes: Option[Iterable[zio.aws.config.model.ComplianceType]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest = {
    import GetComplianceDetailsByResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest
      .builder()
      .resourceType(
        StringWithCharLimit256.unwrap(resourceType): java.lang.String
      )
      .resourceId(BaseResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        complianceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.complianceTypesWithStrings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetComplianceDetailsByResourceRequest.ReadOnly =
    zio.aws.config.model.GetComplianceDetailsByResourceRequest
      .wrap(buildAwsValue())
}
object GetComplianceDetailsByResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetComplianceDetailsByResourceRequest =
      zio.aws.config.model.GetComplianceDetailsByResourceRequest(
        resourceType,
        resourceId,
        complianceTypes.map(value => value),
        nextToken.map(value => value)
      )
    def resourceType: StringWithCharLimit256
    def resourceId: BaseResourceId
    def complianceTypes: Option[List[zio.aws.config.model.ComplianceType]]
    def nextToken: Option[String]
    def getResourceType: ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, BaseResourceId] =
      ZIO.succeed(resourceId)
    def getComplianceTypes
        : ZIO[Any, AwsError, List[zio.aws.config.model.ComplianceType]] =
      AwsError.unwrapOptionField("complianceTypes", complianceTypes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest
  ) extends zio.aws.config.model.GetComplianceDetailsByResourceRequest.ReadOnly {
    override val resourceType: StringWithCharLimit256 =
      zio.aws.config.model.primitives
        .StringWithCharLimit256(impl.resourceType())
    override val resourceId: BaseResourceId =
      zio.aws.config.model.primitives.BaseResourceId(impl.resourceId())
    override val complianceTypes
        : Option[List[zio.aws.config.model.ComplianceType]] = scala
      .Option(impl.complianceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ComplianceType.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest
  ): zio.aws.config.model.GetComplianceDetailsByResourceRequest.ReadOnly =
    new Wrapper(impl)
}
