package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.FieldName
import scala.jdk.CollectionConverters.*
final case class FieldInfo(name: Option[FieldName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.FieldInfo = {
    import FieldInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.FieldInfo
      .builder()
      .optionallyWith(
        name.map(value => FieldName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.config.model.FieldInfo.ReadOnly =
    zio.aws.config.model.FieldInfo.wrap(buildAwsValue())
}
object FieldInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.FieldInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.FieldInfo =
      zio.aws.config.model.FieldInfo(name.map(value => value))
    def name: Option[FieldName]
    def getName: ZIO[Any, AwsError, FieldName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.FieldInfo
  ) extends zio.aws.config.model.FieldInfo.ReadOnly {
    override val name: Option[FieldName] = scala
      .Option(impl.name())
      .map(value => zio.aws.config.model.primitives.FieldName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.FieldInfo
  ): zio.aws.config.model.FieldInfo.ReadOnly = new Wrapper(impl)
}
