package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{Limit, ConfigRuleName}
import scala.jdk.CollectionConverters.*
final case class DescribeRemediationExceptionsRequest(
    configRuleName: ConfigRuleName,
    resourceKeys: Option[
      Iterable[zio.aws.config.model.RemediationExceptionResourceKey]
    ] = None,
    limit: Option[Limit] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest = {
    import DescribeRemediationExceptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest
      .builder()
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .optionallyWith(
        resourceKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceKeys)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRemediationExceptionsRequest.ReadOnly =
    zio.aws.config.model.DescribeRemediationExceptionsRequest
      .wrap(buildAwsValue())
}
object DescribeRemediationExceptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeRemediationExceptionsRequest =
      zio.aws.config.model.DescribeRemediationExceptionsRequest(
        configRuleName,
        resourceKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def configRuleName: ConfigRuleName
    def resourceKeys: Option[
      List[zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly]
    ]
    def limit: Option[Limit]
    def nextToken: Option[String]
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
    def getResourceKeys: ZIO[Any, AwsError, List[
      zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceKeys", resourceKeys)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest
  ) extends zio.aws.config.model.DescribeRemediationExceptionsRequest.ReadOnly {
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
    override val resourceKeys: Option[
      List[zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly]
    ] = scala
      .Option(impl.resourceKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.RemediationExceptionResourceKey.wrap(item)
        }.toList
      )
    override val limit: Option[Limit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest
  ): zio.aws.config.model.DescribeRemediationExceptionsRequest.ReadOnly =
    new Wrapper(impl)
}
