package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeComplianceByConfigRuleResponse(
    complianceByConfigRules: Option[
      Iterable[zio.aws.config.model.ComplianceByConfigRule]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse = {
    import DescribeComplianceByConfigRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse
      .builder()
      .optionallyWith(
        complianceByConfigRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceByConfigRules)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly =
    zio.aws.config.model.DescribeComplianceByConfigRuleResponse
      .wrap(buildAwsValue())
}
object DescribeComplianceByConfigRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeComplianceByConfigRuleResponse =
      zio.aws.config.model.DescribeComplianceByConfigRuleResponse(
        complianceByConfigRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def complianceByConfigRules
        : Option[List[zio.aws.config.model.ComplianceByConfigRule.ReadOnly]]
    def nextToken: Option[String]
    def getComplianceByConfigRules: ZIO[Any, AwsError, List[
      zio.aws.config.model.ComplianceByConfigRule.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "complianceByConfigRules",
      complianceByConfigRules
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse
  ) extends zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly {
    override val complianceByConfigRules
        : Option[List[zio.aws.config.model.ComplianceByConfigRule.ReadOnly]] =
      scala
        .Option(impl.complianceByConfigRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ComplianceByConfigRule.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse
  ): zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly =
    new Wrapper(impl)
}
