package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class QueryInfo(
    selectFields: Option[Iterable[zio.aws.config.model.FieldInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.QueryInfo = {
    import QueryInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.QueryInfo
      .builder()
      .optionallyWith(
        selectFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.selectFields)
      .build()
  }
  def asReadOnly: zio.aws.config.model.QueryInfo.ReadOnly =
    zio.aws.config.model.QueryInfo.wrap(buildAwsValue())
}
object QueryInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.QueryInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.QueryInfo =
      zio.aws.config.model.QueryInfo(
        selectFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def selectFields: Option[List[zio.aws.config.model.FieldInfo.ReadOnly]]
    def getSelectFields
        : ZIO[Any, AwsError, List[zio.aws.config.model.FieldInfo.ReadOnly]] =
      AwsError.unwrapOptionField("selectFields", selectFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.QueryInfo
  ) extends zio.aws.config.model.QueryInfo.ReadOnly {
    override val selectFields
        : Option[List[zio.aws.config.model.FieldInfo.ReadOnly]] = scala
      .Option(impl.selectFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.FieldInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.QueryInfo
  ): zio.aws.config.model.QueryInfo.ReadOnly = new Wrapper(impl)
}
