package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class OrganizationResourceDetailedStatusFilters(
    accountId: Option[AccountId] = None,
    status: Option[zio.aws.config.model.OrganizationResourceDetailedStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.OrganizationResourceDetailedStatusFilters = {
    import OrganizationResourceDetailedStatusFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.OrganizationResourceDetailedStatusFilters
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.OrganizationResourceDetailedStatusFilters.ReadOnly =
    zio.aws.config.model.OrganizationResourceDetailedStatusFilters
      .wrap(buildAwsValue())
}
object OrganizationResourceDetailedStatusFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.OrganizationResourceDetailedStatusFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.OrganizationResourceDetailedStatusFilters =
      zio.aws.config.model.OrganizationResourceDetailedStatusFilters(
        accountId.map(value => value),
        status.map(value => value)
      )
    def accountId: Option[AccountId]
    def status: Option[zio.aws.config.model.OrganizationResourceDetailedStatus]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationResourceDetailedStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.OrganizationResourceDetailedStatusFilters
  ) extends zio.aws.config.model.OrganizationResourceDetailedStatusFilters.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val status
        : Option[zio.aws.config.model.OrganizationResourceDetailedStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.config.model.OrganizationResourceDetailedStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.OrganizationResourceDetailedStatusFilters
  ): zio.aws.config.model.OrganizationResourceDetailedStatusFilters.ReadOnly =
    new Wrapper(impl)
}
