package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  DeliveryS3KeyPrefix,
  OrganizationConformancePackName,
  DeliveryS3Bucket,
  Date,
  AccountId,
  StringWithCharLimit256
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OrganizationConformancePack(
    organizationConformancePackName: OrganizationConformancePackName,
    organizationConformancePackArn: StringWithCharLimit256,
    deliveryS3Bucket: Option[DeliveryS3Bucket] = None,
    deliveryS3KeyPrefix: Option[DeliveryS3KeyPrefix] = None,
    conformancePackInputParameters: Option[
      Iterable[zio.aws.config.model.ConformancePackInputParameter]
    ] = None,
    excludedAccounts: Option[Iterable[AccountId]] = None,
    lastUpdateTime: Date
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.OrganizationConformancePack = {
    import OrganizationConformancePack.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.OrganizationConformancePack
      .builder()
      .organizationConformancePackName(
        OrganizationConformancePackName.unwrap(
          organizationConformancePackName
        ): java.lang.String
      )
      .organizationConformancePackArn(
        StringWithCharLimit256.unwrap(
          organizationConformancePackArn
        ): java.lang.String
      )
      .optionallyWith(
        deliveryS3Bucket.map(value =>
          DeliveryS3Bucket.unwrap(value): java.lang.String
        )
      )(_.deliveryS3Bucket)
      .optionallyWith(
        deliveryS3KeyPrefix.map(value =>
          DeliveryS3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.deliveryS3KeyPrefix)
      .optionallyWith(
        conformancePackInputParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conformancePackInputParameters)
      .optionallyWith(
        excludedAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedAccounts)
      .lastUpdateTime(Date.unwrap(lastUpdateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.config.model.OrganizationConformancePack.ReadOnly =
    zio.aws.config.model.OrganizationConformancePack.wrap(buildAwsValue())
}
object OrganizationConformancePack {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.OrganizationConformancePack
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.OrganizationConformancePack =
      zio.aws.config.model.OrganizationConformancePack(
        organizationConformancePackName,
        organizationConformancePackArn,
        deliveryS3Bucket.map(value => value),
        deliveryS3KeyPrefix.map(value => value),
        conformancePackInputParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        excludedAccounts.map(value => value),
        lastUpdateTime
      )
    def organizationConformancePackName: OrganizationConformancePackName
    def organizationConformancePackArn: StringWithCharLimit256
    def deliveryS3Bucket: Option[DeliveryS3Bucket]
    def deliveryS3KeyPrefix: Option[DeliveryS3KeyPrefix]
    def conformancePackInputParameters: Option[
      List[zio.aws.config.model.ConformancePackInputParameter.ReadOnly]
    ]
    def excludedAccounts: Option[List[AccountId]]
    def lastUpdateTime: Date
    def getOrganizationConformancePackName
        : ZIO[Any, Nothing, OrganizationConformancePackName] =
      ZIO.succeed(organizationConformancePackName)
    def getOrganizationConformancePackArn
        : ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(organizationConformancePackArn)
    def getDeliveryS3Bucket: ZIO[Any, AwsError, DeliveryS3Bucket] =
      AwsError.unwrapOptionField("deliveryS3Bucket", deliveryS3Bucket)
    def getDeliveryS3KeyPrefix: ZIO[Any, AwsError, DeliveryS3KeyPrefix] =
      AwsError.unwrapOptionField("deliveryS3KeyPrefix", deliveryS3KeyPrefix)
    def getConformancePackInputParameters: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConformancePackInputParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "conformancePackInputParameters",
      conformancePackInputParameters
    )
    def getExcludedAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("excludedAccounts", excludedAccounts)
    def getLastUpdateTime: ZIO[Any, Nothing, Date] = ZIO.succeed(lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.OrganizationConformancePack
  ) extends zio.aws.config.model.OrganizationConformancePack.ReadOnly {
    override val organizationConformancePackName
        : OrganizationConformancePackName = zio.aws.config.model.primitives
      .OrganizationConformancePackName(impl.organizationConformancePackName())
    override val organizationConformancePackArn: StringWithCharLimit256 =
      zio.aws.config.model.primitives
        .StringWithCharLimit256(impl.organizationConformancePackArn())
    override val deliveryS3Bucket: Option[DeliveryS3Bucket] = scala
      .Option(impl.deliveryS3Bucket())
      .map(value => zio.aws.config.model.primitives.DeliveryS3Bucket(value))
    override val deliveryS3KeyPrefix: Option[DeliveryS3KeyPrefix] = scala
      .Option(impl.deliveryS3KeyPrefix())
      .map(value => zio.aws.config.model.primitives.DeliveryS3KeyPrefix(value))
    override val conformancePackInputParameters: Option[
      List[zio.aws.config.model.ConformancePackInputParameter.ReadOnly]
    ] = scala
      .Option(impl.conformancePackInputParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConformancePackInputParameter.wrap(item)
        }.toList
      )
    override val excludedAccounts: Option[List[AccountId]] = scala
      .Option(impl.excludedAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.AccountId(item)
        }.toList
      )
    override val lastUpdateTime: Date =
      zio.aws.config.model.primitives.Date(impl.lastUpdateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.OrganizationConformancePack
  ): zio.aws.config.model.OrganizationConformancePack.ReadOnly = new Wrapper(
    impl
  )
}
