package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListStoredQueriesResponse(
    storedQueryMetadata: Option[
      Iterable[zio.aws.config.model.StoredQueryMetadata]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListStoredQueriesResponse = {
    import ListStoredQueriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListStoredQueriesResponse
      .builder()
      .optionallyWith(
        storedQueryMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storedQueryMetadata)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ListStoredQueriesResponse.ReadOnly =
    zio.aws.config.model.ListStoredQueriesResponse.wrap(buildAwsValue())
}
object ListStoredQueriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListStoredQueriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ListStoredQueriesResponse =
      zio.aws.config.model.ListStoredQueriesResponse(
        storedQueryMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def storedQueryMetadata
        : Option[List[zio.aws.config.model.StoredQueryMetadata.ReadOnly]]
    def nextToken: Option[String]
    def getStoredQueryMetadata: ZIO[Any, AwsError, List[
      zio.aws.config.model.StoredQueryMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("storedQueryMetadata", storedQueryMetadata)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListStoredQueriesResponse
  ) extends zio.aws.config.model.ListStoredQueriesResponse.ReadOnly {
    override val storedQueryMetadata
        : Option[List[zio.aws.config.model.StoredQueryMetadata.ReadOnly]] =
      scala
        .Option(impl.storedQueryMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.StoredQueryMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListStoredQueriesResponse
  ): zio.aws.config.model.ListStoredQueriesResponse.ReadOnly = new Wrapper(impl)
}
