package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOrganizationConfigRuleDetailedStatusResponse(
    organizationConfigRuleDetailedStatus: Option[
      Iterable[zio.aws.config.model.MemberAccountStatus]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse = {
    import GetOrganizationConfigRuleDetailedStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse
      .builder()
      .optionallyWith(
        organizationConfigRuleDetailedStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.organizationConfigRuleDetailedStatus)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse.ReadOnly =
    zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse
      .wrap(buildAwsValue())
}
object GetOrganizationConfigRuleDetailedStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse =
      zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse(
        organizationConfigRuleDetailedStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def organizationConfigRuleDetailedStatus
        : Option[List[zio.aws.config.model.MemberAccountStatus.ReadOnly]]
    def nextToken: Option[String]
    def getOrganizationConfigRuleDetailedStatus: ZIO[Any, AwsError, List[
      zio.aws.config.model.MemberAccountStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "organizationConfigRuleDetailedStatus",
      organizationConfigRuleDetailedStatus
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse
  ) extends zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse.ReadOnly {
    override val organizationConfigRuleDetailedStatus
        : Option[List[zio.aws.config.model.MemberAccountStatus.ReadOnly]] =
      scala
        .Option(impl.organizationConfigRuleDetailedStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.MemberAccountStatus.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse
  ): zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse.ReadOnly =
    new Wrapper(impl)
}
