package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class GetComplianceDetailsByConfigRuleResponse(
    evaluationResults: Option[Iterable[zio.aws.config.model.EvaluationResult]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse = {
    import GetComplianceDetailsByConfigRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse
      .builder()
      .optionallyWith(
        evaluationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evaluationResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse.ReadOnly =
    zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse
      .wrap(buildAwsValue())
}
object GetComplianceDetailsByConfigRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse =
      zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse(
        evaluationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def evaluationResults
        : Option[List[zio.aws.config.model.EvaluationResult.ReadOnly]]
    def nextToken: Option[NextToken]
    def getEvaluationResults: ZIO[Any, AwsError, List[
      zio.aws.config.model.EvaluationResult.ReadOnly
    ]] = AwsError.unwrapOptionField("evaluationResults", evaluationResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse
  ) extends zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse.ReadOnly {
    override val evaluationResults
        : Option[List[zio.aws.config.model.EvaluationResult.ReadOnly]] = scala
      .Option(impl.evaluationResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.EvaluationResult.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse
  ): zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse.ReadOnly =
    new Wrapper(impl)
}
