package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FailedDeleteRemediationExceptionsBatch(
    failureMessage: Option[String] = None,
    failedItems: Option[
      Iterable[zio.aws.config.model.RemediationExceptionResourceKey]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.FailedDeleteRemediationExceptionsBatch = {
    import FailedDeleteRemediationExceptionsBatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.FailedDeleteRemediationExceptionsBatch
      .builder()
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(
        failedItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedItems)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.FailedDeleteRemediationExceptionsBatch.ReadOnly =
    zio.aws.config.model.FailedDeleteRemediationExceptionsBatch
      .wrap(buildAwsValue())
}
object FailedDeleteRemediationExceptionsBatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.FailedDeleteRemediationExceptionsBatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.FailedDeleteRemediationExceptionsBatch =
      zio.aws.config.model.FailedDeleteRemediationExceptionsBatch(
        failureMessage.map(value => value),
        failedItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failureMessage: Option[String]
    def failedItems: Option[
      List[zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly]
    ]
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getFailedItems: ZIO[Any, AwsError, List[
      zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly
    ]] = AwsError.unwrapOptionField("failedItems", failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.FailedDeleteRemediationExceptionsBatch
  ) extends zio.aws.config.model.FailedDeleteRemediationExceptionsBatch.ReadOnly {
    override val failureMessage: Option[String] =
      scala.Option(impl.failureMessage()).map(value => value: String)
    override val failedItems: Option[
      List[zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly]
    ] = scala
      .Option(impl.failedItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.RemediationExceptionResourceKey.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.FailedDeleteRemediationExceptionsBatch
  ): zio.aws.config.model.FailedDeleteRemediationExceptionsBatch.ReadOnly =
    new Wrapper(impl)
}
