package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConfigRuleStatusesResponse(
    organizationConfigRuleStatuses: Option[
      Iterable[zio.aws.config.model.OrganizationConfigRuleStatus]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse = {
    import DescribeOrganizationConfigRuleStatusesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse
      .builder()
      .optionallyWith(
        organizationConfigRuleStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.organizationConfigRuleStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly =
    zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConfigRuleStatusesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse =
      zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse(
        organizationConfigRuleStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def organizationConfigRuleStatuses: Option[
      List[zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly]
    ]
    def nextToken: Option[String]
    def getOrganizationConfigRuleStatuses: ZIO[Any, AwsError, List[
      zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "organizationConfigRuleStatuses",
      organizationConfigRuleStatuses
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse
  ) extends zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly {
    override val organizationConfigRuleStatuses: Option[
      List[zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly]
    ] = scala
      .Option(impl.organizationConfigRuleStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.OrganizationConfigRuleStatus.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse
  ): zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly =
    new Wrapper(impl)
}
