package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationRecordersResponse(
    configurationRecorders: Option[
      Iterable[zio.aws.config.model.ConfigurationRecorder]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse = {
    import DescribeConfigurationRecordersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse
      .builder()
      .optionallyWith(
        configurationRecorders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurationRecorders)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigurationRecordersResponse.ReadOnly =
    zio.aws.config.model.DescribeConfigurationRecordersResponse
      .wrap(buildAwsValue())
}
object DescribeConfigurationRecordersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConfigurationRecordersResponse =
      zio.aws.config.model.DescribeConfigurationRecordersResponse(
        configurationRecorders.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configurationRecorders
        : Option[List[zio.aws.config.model.ConfigurationRecorder.ReadOnly]]
    def getConfigurationRecorders: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConfigurationRecorder.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "configurationRecorders",
      configurationRecorders
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse
  ) extends zio.aws.config.model.DescribeConfigurationRecordersResponse.ReadOnly {
    override val configurationRecorders
        : Option[List[zio.aws.config.model.ConfigurationRecorder.ReadOnly]] =
      scala
        .Option(impl.configurationRecorders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ConfigurationRecorder.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse
  ): zio.aws.config.model.DescribeConfigurationRecordersResponse.ReadOnly =
    new Wrapper(impl)
}
