package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{Limit, ConfigurationAggregatorName}
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationAggregatorsRequest(
    configurationAggregatorNames: Option[
      Iterable[ConfigurationAggregatorName]
    ] = None,
    nextToken: Option[String] = None,
    limit: Option[Limit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest = {
    import DescribeConfigurationAggregatorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest
      .builder()
      .optionallyWith(
        configurationAggregatorNames.map(value =>
          value.map { item =>
            ConfigurationAggregatorName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configurationAggregatorNames)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigurationAggregatorsRequest.ReadOnly =
    zio.aws.config.model.DescribeConfigurationAggregatorsRequest
      .wrap(buildAwsValue())
}
object DescribeConfigurationAggregatorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConfigurationAggregatorsRequest =
      zio.aws.config.model.DescribeConfigurationAggregatorsRequest(
        configurationAggregatorNames.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def configurationAggregatorNames: Option[List[ConfigurationAggregatorName]]
    def nextToken: Option[String]
    def limit: Option[Limit]
    def getConfigurationAggregatorNames
        : ZIO[Any, AwsError, List[ConfigurationAggregatorName]] =
      AwsError.unwrapOptionField(
        "configurationAggregatorNames",
        configurationAggregatorNames
      )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest
  ) extends zio.aws.config.model.DescribeConfigurationAggregatorsRequest.ReadOnly {
    override val configurationAggregatorNames
        : Option[List[ConfigurationAggregatorName]] = scala
      .Option(impl.configurationAggregatorNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.ConfigurationAggregatorName(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val limit: Option[Limit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest
  ): zio.aws.config.model.DescribeConfigurationAggregatorsRequest.ReadOnly =
    new Wrapper(impl)
}
