package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{Limit, ConfigurationAggregatorName}
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationAggregatorSourcesStatusRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    updateStatus: Option[
      Iterable[zio.aws.config.model.AggregatedSourceStatusType]
    ] = None,
    nextToken: Option[String] = None,
    limit: Option[Limit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest = {
    import DescribeConfigurationAggregatorSourcesStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .optionallyWith(
        updateStatus.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.updateStatusWithStrings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest.ReadOnly =
    zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
      .wrap(buildAwsValue())
}
object DescribeConfigurationAggregatorSourcesStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest =
      zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest(
        configurationAggregatorName,
        updateStatus.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def updateStatus
        : Option[List[zio.aws.config.model.AggregatedSourceStatusType]]
    def nextToken: Option[String]
    def limit: Option[Limit]
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getUpdateStatus: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregatedSourceStatusType
    ]] = AwsError.unwrapOptionField("updateStatus", updateStatus)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
  ) extends zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val updateStatus
        : Option[List[zio.aws.config.model.AggregatedSourceStatusType]] = scala
      .Option(impl.updateStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.AggregatedSourceStatusType.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val limit: Option[Limit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
  ): zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest.ReadOnly =
    new Wrapper(impl)
}
