package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ChannelName
import scala.jdk.CollectionConverters.*
final case class DeliveryChannel(
    name: Option[ChannelName] = None,
    s3BucketName: Option[String] = None,
    s3KeyPrefix: Option[String] = None,
    s3KmsKeyArn: Option[String] = None,
    snsTopicARN: Option[String] = None,
    configSnapshotDeliveryProperties: Option[
      zio.aws.config.model.ConfigSnapshotDeliveryProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeliveryChannel = {
    import DeliveryChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeliveryChannel
      .builder()
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(s3BucketName.map(value => value: java.lang.String))(
        _.s3BucketName
      )
      .optionallyWith(s3KeyPrefix.map(value => value: java.lang.String))(
        _.s3KeyPrefix
      )
      .optionallyWith(s3KmsKeyArn.map(value => value: java.lang.String))(
        _.s3KmsKeyArn
      )
      .optionallyWith(snsTopicARN.map(value => value: java.lang.String))(
        _.snsTopicARN
      )
      .optionallyWith(
        configSnapshotDeliveryProperties.map(value => value.buildAwsValue())
      )(_.configSnapshotDeliveryProperties)
      .build()
  }
  def asReadOnly: zio.aws.config.model.DeliveryChannel.ReadOnly =
    zio.aws.config.model.DeliveryChannel.wrap(buildAwsValue())
}
object DeliveryChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeliveryChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeliveryChannel =
      zio.aws.config.model.DeliveryChannel(
        name.map(value => value),
        s3BucketName.map(value => value),
        s3KeyPrefix.map(value => value),
        s3KmsKeyArn.map(value => value),
        snsTopicARN.map(value => value),
        configSnapshotDeliveryProperties.map(value => value.asEditable)
      )
    def name: Option[ChannelName]
    def s3BucketName: Option[String]
    def s3KeyPrefix: Option[String]
    def s3KmsKeyArn: Option[String]
    def snsTopicARN: Option[String]
    def configSnapshotDeliveryProperties
        : Option[zio.aws.config.model.ConfigSnapshotDeliveryProperties.ReadOnly]
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getS3BucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getS3KmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3KmsKeyArn", s3KmsKeyArn)
    def getSnsTopicARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicARN", snsTopicARN)
    def getConfigSnapshotDeliveryProperties: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConfigSnapshotDeliveryProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "configSnapshotDeliveryProperties",
      configSnapshotDeliveryProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeliveryChannel
  ) extends zio.aws.config.model.DeliveryChannel.ReadOnly {
    override val name: Option[ChannelName] = scala
      .Option(impl.name())
      .map(value => zio.aws.config.model.primitives.ChannelName(value))
    override val s3BucketName: Option[String] =
      scala.Option(impl.s3BucketName()).map(value => value: String)
    override val s3KeyPrefix: Option[String] =
      scala.Option(impl.s3KeyPrefix()).map(value => value: String)
    override val s3KmsKeyArn: Option[String] =
      scala.Option(impl.s3KmsKeyArn()).map(value => value: String)
    override val snsTopicARN: Option[String] =
      scala.Option(impl.snsTopicARN()).map(value => value: String)
    override val configSnapshotDeliveryProperties: Option[
      zio.aws.config.model.ConfigSnapshotDeliveryProperties.ReadOnly
    ] = scala
      .Option(impl.configSnapshotDeliveryProperties())
      .map(value =>
        zio.aws.config.model.ConfigSnapshotDeliveryProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeliveryChannel
  ): zio.aws.config.model.DeliveryChannel.ReadOnly = new Wrapper(impl)
}
