package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait AggregatedSourceStatusType {
  def unwrap
      : software.amazon.awssdk.services.config.model.AggregatedSourceStatusType
}
object AggregatedSourceStatusType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.AggregatedSourceStatusType
  ): zio.aws.config.model.AggregatedSourceStatusType = value match {
    case software.amazon.awssdk.services.config.model.AggregatedSourceStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.AggregatedSourceStatusType.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.config.model.AggregatedSourceStatusType.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.config.model.AggregatedSourceStatusType.OUTDATED =>
      val r = OUTDATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.AggregatedSourceStatusType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.AggregatedSourceStatusType =
      software.amazon.awssdk.services.config.model.AggregatedSourceStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object FAILED extends zio.aws.config.model.AggregatedSourceStatusType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.AggregatedSourceStatusType =
      software.amazon.awssdk.services.config.model.AggregatedSourceStatusType.FAILED
  }
  case object SUCCEEDED
      extends zio.aws.config.model.AggregatedSourceStatusType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.AggregatedSourceStatusType =
      software.amazon.awssdk.services.config.model.AggregatedSourceStatusType.SUCCEEDED
  }
  case object OUTDATED extends zio.aws.config.model.AggregatedSourceStatusType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.AggregatedSourceStatusType =
      software.amazon.awssdk.services.config.model.AggregatedSourceStatusType.OUTDATED
  }
}
