package zio.aws.config
import zio.prelude.Subtype
import zio.aws.config.model.primitives.{
  RelatedEvent,
  ConformancePackName,
  StringWithCharLimit64,
  OrganizationConformancePackName,
  AccountId,
  ConfigurationAggregatorName,
  StringWithCharLimit256,
  SupplementaryConfigurationName,
  Value,
  ChannelName,
  StringWithCharLimit128,
  ConfigRuleName,
  RecorderName,
  Name,
  SupplementaryConfigurationValue,
  ResourceId,
  RetentionConfigurationName,
  TagKey
}
import java.time.Instant
import zio.aws.config.model.primitives.QueryArn.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.config.model.primitives.ARN.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.config.model.primitives.AccountId.Type
    object AllSupported extends Subtype[Boolean]
    type AllSupported = zio.aws.config.model.primitives.AllSupported.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.config.model.primitives.AmazonResourceName.Type
    object Annotation extends Subtype[String]
    type Annotation = zio.aws.config.model.primitives.Annotation.Type
    object AutoRemediationAttemptSeconds extends Subtype[Long]
    type AutoRemediationAttemptSeconds =
      zio.aws.config.model.primitives.AutoRemediationAttemptSeconds.Type
    object AutoRemediationAttempts extends Subtype[Int]
    type AutoRemediationAttempts =
      zio.aws.config.model.primitives.AutoRemediationAttempts.Type
    object AvailabilityZone extends Subtype[String]
    type AvailabilityZone =
      zio.aws.config.model.primitives.AvailabilityZone.Type
    object AwsRegion extends Subtype[String]
    type AwsRegion = zio.aws.config.model.primitives.AwsRegion.Type
    object BaseResourceId extends Subtype[String]
    type BaseResourceId = zio.aws.config.model.primitives.BaseResourceId.Type
    object ChannelName extends Subtype[String]
    type ChannelName = zio.aws.config.model.primitives.ChannelName.Type
    object ConfigRuleName extends Subtype[String]
    type ConfigRuleName = zio.aws.config.model.primitives.ConfigRuleName.Type
    object Configuration extends Subtype[String]
    type Configuration = zio.aws.config.model.primitives.Configuration.Type
    object ConfigurationAggregatorArn extends Subtype[String]
    type ConfigurationAggregatorArn =
      zio.aws.config.model.primitives.ConfigurationAggregatorArn.Type
    object ConfigurationAggregatorName extends Subtype[String]
    type ConfigurationAggregatorName =
      zio.aws.config.model.primitives.ConfigurationAggregatorName.Type
    object ConfigurationItemCaptureTime extends Subtype[Instant]
    type ConfigurationItemCaptureTime =
      zio.aws.config.model.primitives.ConfigurationItemCaptureTime.Type
    object ConfigurationItemMD5Hash extends Subtype[String]
    type ConfigurationItemMD5Hash =
      zio.aws.config.model.primitives.ConfigurationItemMD5Hash.Type
    object ConfigurationStateId extends Subtype[String]
    type ConfigurationStateId =
      zio.aws.config.model.primitives.ConfigurationStateId.Type
    object ConformancePackArn extends Subtype[String]
    type ConformancePackArn =
      zio.aws.config.model.primitives.ConformancePackArn.Type
    object ConformancePackId extends Subtype[String]
    type ConformancePackId =
      zio.aws.config.model.primitives.ConformancePackId.Type
    object ConformancePackName extends Subtype[String]
    type ConformancePackName =
      zio.aws.config.model.primitives.ConformancePackName.Type
    object ConformancePackStatusReason extends Subtype[String]
    type ConformancePackStatusReason =
      zio.aws.config.model.primitives.ConformancePackStatusReason.Type
    object CosmosPageLimit extends Subtype[Int]
    type CosmosPageLimit = zio.aws.config.model.primitives.CosmosPageLimit.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.config.model.primitives.Date.Type
    object DeliveryS3Bucket extends Subtype[String]
    type DeliveryS3Bucket =
      zio.aws.config.model.primitives.DeliveryS3Bucket.Type
    object DeliveryS3KeyPrefix extends Subtype[String]
    type DeliveryS3KeyPrefix =
      zio.aws.config.model.primitives.DeliveryS3KeyPrefix.Type
    object DescribeConformancePackComplianceLimit extends Subtype[Int]
    type DescribeConformancePackComplianceLimit =
      zio.aws.config.model.primitives.DescribeConformancePackComplianceLimit.Type
    object DescribePendingAggregationRequestsLimit extends Subtype[Int]
    type DescribePendingAggregationRequestsLimit =
      zio.aws.config.model.primitives.DescribePendingAggregationRequestsLimit.Type
    object EarlierTime extends Subtype[Instant]
    type EarlierTime = zio.aws.config.model.primitives.EarlierTime.Type
    object EmptiableStringWithCharLimit256 extends Subtype[String]
    type EmptiableStringWithCharLimit256 =
      zio.aws.config.model.primitives.EmptiableStringWithCharLimit256.Type
    object Expression extends Subtype[String]
    type Expression = zio.aws.config.model.primitives.Expression.Type
    object FieldName extends Subtype[String]
    type FieldName = zio.aws.config.model.primitives.FieldName.Type
    object GetConformancePackComplianceDetailsLimit extends Subtype[Int]
    type GetConformancePackComplianceDetailsLimit =
      zio.aws.config.model.primitives.GetConformancePackComplianceDetailsLimit.Type
    object GroupByAPILimit extends Subtype[Int]
    type GroupByAPILimit = zio.aws.config.model.primitives.GroupByAPILimit.Type
    object IncludeGlobalResourceTypes extends Subtype[Boolean]
    type IncludeGlobalResourceTypes =
      zio.aws.config.model.primitives.IncludeGlobalResourceTypes.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.config.model.primitives.Integer.Type
    object LaterTime extends Subtype[Instant]
    type LaterTime = zio.aws.config.model.primitives.LaterTime.Type
    object Limit extends Subtype[Int]
    type Limit = zio.aws.config.model.primitives.Limit.Type
    object Name extends Subtype[String]
    type Name = zio.aws.config.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.config.model.primitives.NextToken.Type
    object OrderingTimestamp extends Subtype[Instant]
    type OrderingTimestamp =
      zio.aws.config.model.primitives.OrderingTimestamp.Type
    object OrganizationConfigRuleName extends Subtype[String]
    type OrganizationConfigRuleName =
      zio.aws.config.model.primitives.OrganizationConfigRuleName.Type
    object OrganizationConformancePackName extends Subtype[String]
    type OrganizationConformancePackName =
      zio.aws.config.model.primitives.OrganizationConformancePackName.Type
    object PageSizeLimit extends Subtype[Int]
    type PageSizeLimit = zio.aws.config.model.primitives.PageSizeLimit.Type
    object ParameterName extends Subtype[String]
    type ParameterName = zio.aws.config.model.primitives.ParameterName.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue = zio.aws.config.model.primitives.ParameterValue.Type
    object Percentage extends Subtype[Int]
    type Percentage = zio.aws.config.model.primitives.Percentage.Type
    object QueryArn extends Subtype[String]
    type QueryArn = zio.aws.config.model.primitives.QueryArn.Type
    object QueryDescription extends Subtype[String]
    type QueryDescription =
      zio.aws.config.model.primitives.QueryDescription.Type
    object QueryExpression extends Subtype[String]
    type QueryExpression = zio.aws.config.model.primitives.QueryExpression.Type
    object QueryId extends Subtype[String]
    type QueryId = zio.aws.config.model.primitives.QueryId.Type
    object QueryName extends Subtype[String]
    type QueryName = zio.aws.config.model.primitives.QueryName.Type
    object RecorderName extends Subtype[String]
    type RecorderName = zio.aws.config.model.primitives.RecorderName.Type
    object RelatedEvent extends Subtype[String]
    type RelatedEvent = zio.aws.config.model.primitives.RelatedEvent.Type
    object RelationshipName extends Subtype[String]
    type RelationshipName =
      zio.aws.config.model.primitives.RelationshipName.Type
    object ResourceCreationTime extends Subtype[Instant]
    type ResourceCreationTime =
      zio.aws.config.model.primitives.ResourceCreationTime.Type
    object ResourceDeletionTime extends Subtype[Instant]
    type ResourceDeletionTime =
      zio.aws.config.model.primitives.ResourceDeletionTime.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.config.model.primitives.ResourceId.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.config.model.primitives.ResourceName.Type
    object ResourceTypeString extends Subtype[String]
    type ResourceTypeString =
      zio.aws.config.model.primitives.ResourceTypeString.Type
    object RetentionConfigurationName extends Subtype[String]
    type RetentionConfigurationName =
      zio.aws.config.model.primitives.RetentionConfigurationName.Type
    object RetentionPeriodInDays extends Subtype[Int]
    type RetentionPeriodInDays =
      zio.aws.config.model.primitives.RetentionPeriodInDays.Type
    object RuleLimit extends Subtype[Int]
    type RuleLimit = zio.aws.config.model.primitives.RuleLimit.Type
    object SchemaVersionId extends Subtype[String]
    type SchemaVersionId = zio.aws.config.model.primitives.SchemaVersionId.Type
    object StackArn extends Subtype[String]
    type StackArn = zio.aws.config.model.primitives.StackArn.Type
    object StringWithCharLimit1024 extends Subtype[String]
    type StringWithCharLimit1024 =
      zio.aws.config.model.primitives.StringWithCharLimit1024.Type
    object StringWithCharLimit128 extends Subtype[String]
    type StringWithCharLimit128 =
      zio.aws.config.model.primitives.StringWithCharLimit128.Type
    object StringWithCharLimit2048 extends Subtype[String]
    type StringWithCharLimit2048 =
      zio.aws.config.model.primitives.StringWithCharLimit2048.Type
    object StringWithCharLimit256 extends Subtype[String]
    type StringWithCharLimit256 =
      zio.aws.config.model.primitives.StringWithCharLimit256.Type
    object StringWithCharLimit256Min0 extends Subtype[String]
    type StringWithCharLimit256Min0 =
      zio.aws.config.model.primitives.StringWithCharLimit256Min0.Type
    object StringWithCharLimit64 extends Subtype[String]
    type StringWithCharLimit64 =
      zio.aws.config.model.primitives.StringWithCharLimit64.Type
    object StringWithCharLimit768 extends Subtype[String]
    type StringWithCharLimit768 =
      zio.aws.config.model.primitives.StringWithCharLimit768.Type
    object SupplementaryConfigurationName extends Subtype[String]
    type SupplementaryConfigurationName =
      zio.aws.config.model.primitives.SupplementaryConfigurationName.Type
    object SupplementaryConfigurationValue extends Subtype[String]
    type SupplementaryConfigurationValue =
      zio.aws.config.model.primitives.SupplementaryConfigurationValue.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.config.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.config.model.primitives.TagValue.Type
    object TemplateBody extends Subtype[String]
    type TemplateBody = zio.aws.config.model.primitives.TemplateBody.Type
    object TemplateS3Uri extends Subtype[String]
    type TemplateS3Uri = zio.aws.config.model.primitives.TemplateS3Uri.Type
    object Value extends Subtype[String]
    type Value = zio.aws.config.model.primitives.Value.Type
    object Version extends Subtype[String]
    type Version = zio.aws.config.model.primitives.Version.Type
  }
  type AccountAggregationSourceAccountList = List[AccountId]
  type AccountAggregationSourceList =
    List[zio.aws.config.model.AccountAggregationSource]
  type AggregateComplianceByConfigRuleList =
    List[zio.aws.config.model.AggregateComplianceByConfigRule]
  type AggregateComplianceByConformancePackList =
    List[zio.aws.config.model.AggregateComplianceByConformancePack]
  type AggregateComplianceCountList =
    List[zio.aws.config.model.AggregateComplianceCount]
  type AggregateConformancePackComplianceSummaryList =
    List[zio.aws.config.model.AggregateConformancePackComplianceSummary]
  type AggregateEvaluationResultList =
    List[zio.aws.config.model.AggregateEvaluationResult]
  type AggregatedSourceStatusList =
    List[zio.aws.config.model.AggregatedSourceStatus]
  type AggregatedSourceStatusTypeList =
    List[zio.aws.config.model.AggregatedSourceStatusType]
  type AggregationAuthorizationList =
    List[zio.aws.config.model.AggregationAuthorization]
  type AggregatorRegionList = List[String]
  type BaseConfigurationItems = List[zio.aws.config.model.BaseConfigurationItem]
  type ComplianceByConfigRules =
    List[zio.aws.config.model.ComplianceByConfigRule]
  type ComplianceByResources = List[zio.aws.config.model.ComplianceByResource]
  type ComplianceResourceTypes = List[StringWithCharLimit256]
  type ComplianceSummariesByResourceType =
    List[zio.aws.config.model.ComplianceSummaryByResourceType]
  type ComplianceTypes = List[zio.aws.config.model.ComplianceType]
  type ConfigRuleEvaluationStatusList =
    List[zio.aws.config.model.ConfigRuleEvaluationStatus]
  type ConfigRuleNames = List[ConfigRuleName]
  type ConfigRules = List[zio.aws.config.model.ConfigRule]
  type ConfigurationAggregatorList =
    List[zio.aws.config.model.ConfigurationAggregator]
  type ConfigurationAggregatorNameList = List[ConfigurationAggregatorName]
  type ConfigurationItemList = List[zio.aws.config.model.ConfigurationItem]
  type ConfigurationRecorderList =
    List[zio.aws.config.model.ConfigurationRecorder]
  type ConfigurationRecorderNameList = List[RecorderName]
  type ConfigurationRecorderStatusList =
    List[zio.aws.config.model.ConfigurationRecorderStatus]
  type ConformancePackComplianceResourceIds = List[StringWithCharLimit256]
  type ConformancePackComplianceSummaryList =
    List[zio.aws.config.model.ConformancePackComplianceSummary]
  type ConformancePackConfigRuleNames = List[StringWithCharLimit64]
  type ConformancePackDetailList =
    List[zio.aws.config.model.ConformancePackDetail]
  type ConformancePackInputParameters =
    List[zio.aws.config.model.ConformancePackInputParameter]
  type ConformancePackNamesList = List[ConformancePackName]
  type ConformancePackNamesToSummarizeList = List[ConformancePackName]
  type ConformancePackRuleComplianceList =
    List[zio.aws.config.model.ConformancePackRuleCompliance]
  type ConformancePackRuleEvaluationResultsList =
    List[zio.aws.config.model.ConformancePackEvaluationResult]
  type ConformancePackStatusDetailsList =
    List[zio.aws.config.model.ConformancePackStatusDetail]
  type ControlsList = List[StringWithCharLimit128]
  type DeliveryChannelList = List[zio.aws.config.model.DeliveryChannel]
  type DeliveryChannelNameList = List[ChannelName]
  type DeliveryChannelStatusList =
    List[zio.aws.config.model.DeliveryChannelStatus]
  type DiscoveredResourceIdentifierList =
    List[zio.aws.config.model.AggregateResourceIdentifier]
  type EvaluationResults = List[zio.aws.config.model.EvaluationResult]
  type Evaluations = List[zio.aws.config.model.Evaluation]
  type ExcludedAccounts = List[AccountId]
  type FailedDeleteRemediationExceptionsBatches =
    List[zio.aws.config.model.FailedDeleteRemediationExceptionsBatch]
  type FailedRemediationBatches =
    List[zio.aws.config.model.FailedRemediationBatch]
  type FailedRemediationExceptionBatches =
    List[zio.aws.config.model.FailedRemediationExceptionBatch]
  type FieldInfoList = List[zio.aws.config.model.FieldInfo]
  type GroupedResourceCountList =
    List[zio.aws.config.model.GroupedResourceCount]
  type OrganizationConfigRuleDetailedStatus =
    List[zio.aws.config.model.MemberAccountStatus]
  type OrganizationConfigRuleNames = List[StringWithCharLimit64]
  type OrganizationConfigRuleStatuses =
    List[zio.aws.config.model.OrganizationConfigRuleStatus]
  type OrganizationConfigRuleTriggerTypes =
    List[zio.aws.config.model.OrganizationConfigRuleTriggerType]
  type OrganizationConfigRules =
    List[zio.aws.config.model.OrganizationConfigRule]
  type OrganizationConformancePackDetailedStatuses =
    List[zio.aws.config.model.OrganizationConformancePackDetailedStatus]
  type OrganizationConformancePackNames = List[OrganizationConformancePackName]
  type OrganizationConformancePackStatuses =
    List[zio.aws.config.model.OrganizationConformancePackStatus]
  type OrganizationConformancePacks =
    List[zio.aws.config.model.OrganizationConformancePack]
  type PendingAggregationRequestList =
    List[zio.aws.config.model.PendingAggregationRequest]
  type ReevaluateConfigRuleNames = List[ConfigRuleName]
  type RelatedEventList = List[RelatedEvent]
  type RelationshipList = List[zio.aws.config.model.Relationship]
  type RemediationConfigurations =
    List[zio.aws.config.model.RemediationConfiguration]
  type RemediationExceptionResourceKeys =
    List[zio.aws.config.model.RemediationExceptionResourceKey]
  type RemediationExceptions = List[zio.aws.config.model.RemediationException]
  type RemediationExecutionStatuses =
    List[zio.aws.config.model.RemediationExecutionStatus]
  type RemediationExecutionSteps =
    List[zio.aws.config.model.RemediationExecutionStep]
  type RemediationParameters =
    Map[StringWithCharLimit256, zio.aws.config.model.RemediationParameterValue]
  type ResourceCounts = List[zio.aws.config.model.ResourceCount]
  type ResourceIdList = List[ResourceId]
  type ResourceIdentifierList = List[zio.aws.config.model.ResourceIdentifier]
  type ResourceIdentifiersList =
    List[zio.aws.config.model.AggregateResourceIdentifier]
  type ResourceKeys = List[zio.aws.config.model.ResourceKey]
  type ResourceTypeList = List[zio.aws.config.model.ResourceType]
  type ResourceTypes = List[StringWithCharLimit256]
  type ResourceTypesScope = List[StringWithCharLimit256]
  type Results = List[String]
  type RetentionConfigurationList =
    List[zio.aws.config.model.RetentionConfiguration]
  type RetentionConfigurationNameList = List[RetentionConfigurationName]
  type SourceDetails = List[zio.aws.config.model.SourceDetail]
  type StaticParameterValues = List[StringWithCharLimit256]
  type StoredQueryMetadataList = List[zio.aws.config.model.StoredQueryMetadata]
  type SupplementaryConfiguration =
    Map[SupplementaryConfigurationName, SupplementaryConfigurationValue]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.config.model.Tag]
  type Tags = Map[Name, Value]
  type TagsList = List[zio.aws.config.model.Tag]
  type UnprocessedResourceIdentifierList =
    List[zio.aws.config.model.AggregateResourceIdentifier]
}
