package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartRemediationExecutionResponse(
    failureMessage: Option[String] = None,
    failedItems: Option[Iterable[zio.aws.config.model.ResourceKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse = {
    import StartRemediationExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse
      .builder()
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(
        failedItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedItems)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.StartRemediationExecutionResponse.ReadOnly =
    zio.aws.config.model.StartRemediationExecutionResponse.wrap(buildAwsValue())
}
object StartRemediationExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StartRemediationExecutionResponse =
      zio.aws.config.model.StartRemediationExecutionResponse(
        failureMessage.map(value => value),
        failedItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failureMessage: Option[String]
    def failedItems: Option[List[zio.aws.config.model.ResourceKey.ReadOnly]]
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getFailedItems
        : ZIO[Any, AwsError, List[zio.aws.config.model.ResourceKey.ReadOnly]] =
      AwsError.unwrapOptionField("failedItems", failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse
  ) extends zio.aws.config.model.StartRemediationExecutionResponse.ReadOnly {
    override val failureMessage: Option[String] =
      scala.Option(impl.failureMessage()).map(value => value: String)
    override val failedItems
        : Option[List[zio.aws.config.model.ResourceKey.ReadOnly]] = scala
      .Option(impl.failedItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ResourceKey.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse
  ): zio.aws.config.model.StartRemediationExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
