package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  RelationshipName,
  ResourceName,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class Relationship(
    resourceType: Option[zio.aws.config.model.ResourceType] = None,
    resourceId: Option[ResourceId] = None,
    resourceName: Option[ResourceName] = None,
    relationshipName: Option[RelationshipName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.Relationship = {
    import Relationship.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.Relationship
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(
        relationshipName.map(value =>
          RelationshipName.unwrap(value): java.lang.String
        )
      )(_.relationshipName)
      .build()
  }
  def asReadOnly: zio.aws.config.model.Relationship.ReadOnly =
    zio.aws.config.model.Relationship.wrap(buildAwsValue())
}
object Relationship {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.Relationship
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.Relationship =
      zio.aws.config.model.Relationship(
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceName.map(value => value),
        relationshipName.map(value => value)
      )
    def resourceType: Option[zio.aws.config.model.ResourceType]
    def resourceId: Option[ResourceId]
    def resourceName: Option[ResourceName]
    def relationshipName: Option[RelationshipName]
    def getResourceType: ZIO[Any, AwsError, zio.aws.config.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getRelationshipName: ZIO[Any, AwsError, RelationshipName] =
      AwsError.unwrapOptionField("relationshipName", relationshipName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.Relationship
  ) extends zio.aws.config.model.Relationship.ReadOnly {
    override val resourceType: Option[zio.aws.config.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.config.model.ResourceType.wrap(value))
    override val resourceId: Option[ResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.ResourceId(value))
    override val resourceName: Option[ResourceName] = scala
      .Option(impl.resourceName())
      .map(value => zio.aws.config.model.primitives.ResourceName(value))
    override val relationshipName: Option[RelationshipName] = scala
      .Option(impl.relationshipName())
      .map(value => zio.aws.config.model.primitives.RelationshipName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.Relationship
  ): zio.aws.config.model.Relationship.ReadOnly = new Wrapper(impl)
}
