package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ConformancePackArn
import scala.jdk.CollectionConverters.*
final case class PutConformancePackResponse(
    conformancePackArn: Option[ConformancePackArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutConformancePackResponse = {
    import PutConformancePackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutConformancePackResponse
      .builder()
      .optionallyWith(
        conformancePackArn.map(value =>
          ConformancePackArn.unwrap(value): java.lang.String
        )
      )(_.conformancePackArn)
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutConformancePackResponse.ReadOnly =
    zio.aws.config.model.PutConformancePackResponse.wrap(buildAwsValue())
}
object PutConformancePackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutConformancePackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutConformancePackResponse =
      zio.aws.config.model
        .PutConformancePackResponse(conformancePackArn.map(value => value))
    def conformancePackArn: Option[ConformancePackArn]
    def getConformancePackArn: ZIO[Any, AwsError, ConformancePackArn] =
      AwsError.unwrapOptionField("conformancePackArn", conformancePackArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutConformancePackResponse
  ) extends zio.aws.config.model.PutConformancePackResponse.ReadOnly {
    override val conformancePackArn: Option[ConformancePackArn] = scala
      .Option(impl.conformancePackArn())
      .map(value => zio.aws.config.model.primitives.ConformancePackArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutConformancePackResponse
  ): zio.aws.config.model.PutConformancePackResponse.ReadOnly = new Wrapper(
    impl
  )
}
