package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutConfigurationAggregatorResponse(
    configurationAggregator: Option[
      zio.aws.config.model.ConfigurationAggregator
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse = {
    import PutConfigurationAggregatorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse
      .builder()
      .optionallyWith(
        configurationAggregator.map(value => value.buildAwsValue())
      )(_.configurationAggregator)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutConfigurationAggregatorResponse.ReadOnly =
    zio.aws.config.model.PutConfigurationAggregatorResponse
      .wrap(buildAwsValue())
}
object PutConfigurationAggregatorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutConfigurationAggregatorResponse =
      zio.aws.config.model.PutConfigurationAggregatorResponse(
        configurationAggregator.map(value => value.asEditable)
      )
    def configurationAggregator
        : Option[zio.aws.config.model.ConfigurationAggregator.ReadOnly]
    def getConfigurationAggregator: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConfigurationAggregator.ReadOnly
    ] = AwsError.unwrapOptionField(
      "configurationAggregator",
      configurationAggregator
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse
  ) extends zio.aws.config.model.PutConfigurationAggregatorResponse.ReadOnly {
    override val configurationAggregator
        : Option[zio.aws.config.model.ConfigurationAggregator.ReadOnly] = scala
      .Option(impl.configurationAggregator())
      .map(value => zio.aws.config.model.ConfigurationAggregator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse
  ): zio.aws.config.model.PutConfigurationAggregatorResponse.ReadOnly =
    new Wrapper(impl)
}
