package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  CosmosPageLimit,
  OrganizationConformancePackName
}
import scala.jdk.CollectionConverters.*
final case class GetOrganizationConformancePackDetailedStatusRequest(
    organizationConformancePackName: OrganizationConformancePackName,
    filters: Option[
      zio.aws.config.model.OrganizationResourceDetailedStatusFilters
    ] = None,
    limit: Option[CosmosPageLimit] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest = {
    import GetOrganizationConformancePackDetailedStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest
      .builder()
      .organizationConformancePackName(
        OrganizationConformancePackName.unwrap(
          organizationConformancePackName
        ): java.lang.String
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        limit.map(value => CosmosPageLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest.ReadOnly =
    zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest
      .wrap(buildAwsValue())
}
object GetOrganizationConformancePackDetailedStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest =
      zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest(
        organizationConformancePackName,
        filters.map(value => value.asEditable),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def organizationConformancePackName: OrganizationConformancePackName
    def filters: Option[
      zio.aws.config.model.OrganizationResourceDetailedStatusFilters.ReadOnly
    ]
    def limit: Option[CosmosPageLimit]
    def nextToken: Option[String]
    def getOrganizationConformancePackName
        : ZIO[Any, Nothing, OrganizationConformancePackName] =
      ZIO.succeed(organizationConformancePackName)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationResourceDetailedStatusFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getLimit: ZIO[Any, AwsError, CosmosPageLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest
  ) extends zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest.ReadOnly {
    override val organizationConformancePackName
        : OrganizationConformancePackName = zio.aws.config.model.primitives
      .OrganizationConformancePackName(impl.organizationConformancePackName())
    override val filters: Option[
      zio.aws.config.model.OrganizationResourceDetailedStatusFilters.ReadOnly
    ] = scala
      .Option(impl.filters())
      .map(value =>
        zio.aws.config.model.OrganizationResourceDetailedStatusFilters
          .wrap(value)
      )
    override val limit: Option[CosmosPageLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.CosmosPageLimit(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest
  ): zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest.ReadOnly =
    new Wrapper(impl)
}
