package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class GetDiscoveredResourceCountsResponse(
    totalDiscoveredResources: Option[Long] = None,
    resourceCounts: Option[Iterable[zio.aws.config.model.ResourceCount]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse = {
    import GetDiscoveredResourceCountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse
      .builder()
      .optionallyWith(
        totalDiscoveredResources.map(value => value: java.lang.Long)
      )(_.totalDiscoveredResources)
      .optionallyWith(
        resourceCounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceCounts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetDiscoveredResourceCountsResponse.ReadOnly =
    zio.aws.config.model.GetDiscoveredResourceCountsResponse
      .wrap(buildAwsValue())
}
object GetDiscoveredResourceCountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetDiscoveredResourceCountsResponse =
      zio.aws.config.model.GetDiscoveredResourceCountsResponse(
        totalDiscoveredResources.map(value => value),
        resourceCounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def totalDiscoveredResources: Option[Long]
    def resourceCounts
        : Option[List[zio.aws.config.model.ResourceCount.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTotalDiscoveredResources: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("totalDiscoveredResources", totalDiscoveredResources)
    def getResourceCounts: ZIO[Any, AwsError, List[
      zio.aws.config.model.ResourceCount.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceCounts", resourceCounts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse
  ) extends zio.aws.config.model.GetDiscoveredResourceCountsResponse.ReadOnly {
    override val totalDiscoveredResources: Option[Long] =
      scala.Option(impl.totalDiscoveredResources()).map(value => value: Long)
    override val resourceCounts
        : Option[List[zio.aws.config.model.ResourceCount.ReadOnly]] = scala
      .Option(impl.resourceCounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ResourceCount.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse
  ): zio.aws.config.model.GetDiscoveredResourceCountsResponse.ReadOnly =
    new Wrapper(impl)
}
