package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{StringWithCharLimit256, Date}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class EvaluationResult(
    evaluationResultIdentifier: Option[
      zio.aws.config.model.EvaluationResultIdentifier
    ] = None,
    complianceType: Option[zio.aws.config.model.ComplianceType] = None,
    resultRecordedTime: Option[Date] = None,
    configRuleInvokedTime: Option[Date] = None,
    annotation: Option[StringWithCharLimit256] = None,
    resultToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.EvaluationResult = {
    import EvaluationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.EvaluationResult
      .builder()
      .optionallyWith(
        evaluationResultIdentifier.map(value => value.buildAwsValue())
      )(_.evaluationResultIdentifier)
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        resultRecordedTime.map(value => Date.unwrap(value): Instant)
      )(_.resultRecordedTime)
      .optionallyWith(
        configRuleInvokedTime.map(value => Date.unwrap(value): Instant)
      )(_.configRuleInvokedTime)
      .optionallyWith(
        annotation.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.annotation)
      .optionallyWith(resultToken.map(value => value: java.lang.String))(
        _.resultToken
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.EvaluationResult.ReadOnly =
    zio.aws.config.model.EvaluationResult.wrap(buildAwsValue())
}
object EvaluationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.EvaluationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.EvaluationResult =
      zio.aws.config.model.EvaluationResult(
        evaluationResultIdentifier.map(value => value.asEditable),
        complianceType.map(value => value),
        resultRecordedTime.map(value => value),
        configRuleInvokedTime.map(value => value),
        annotation.map(value => value),
        resultToken.map(value => value)
      )
    def evaluationResultIdentifier
        : Option[zio.aws.config.model.EvaluationResultIdentifier.ReadOnly]
    def complianceType: Option[zio.aws.config.model.ComplianceType]
    def resultRecordedTime: Option[Date]
    def configRuleInvokedTime: Option[Date]
    def annotation: Option[StringWithCharLimit256]
    def resultToken: Option[String]
    def getEvaluationResultIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.EvaluationResultIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "evaluationResultIdentifier",
      evaluationResultIdentifier
    )
    def getComplianceType
        : ZIO[Any, AwsError, zio.aws.config.model.ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getResultRecordedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("resultRecordedTime", resultRecordedTime)
    def getConfigRuleInvokedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("configRuleInvokedTime", configRuleInvokedTime)
    def getAnnotation: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("annotation", annotation)
    def getResultToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultToken", resultToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.EvaluationResult
  ) extends zio.aws.config.model.EvaluationResult.ReadOnly {
    override val evaluationResultIdentifier
        : Option[zio.aws.config.model.EvaluationResultIdentifier.ReadOnly] =
      scala
        .Option(impl.evaluationResultIdentifier())
        .map(value =>
          zio.aws.config.model.EvaluationResultIdentifier.wrap(value)
        )
    override val complianceType: Option[zio.aws.config.model.ComplianceType] =
      scala
        .Option(impl.complianceType())
        .map(value => zio.aws.config.model.ComplianceType.wrap(value))
    override val resultRecordedTime: Option[Date] = scala
      .Option(impl.resultRecordedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val configRuleInvokedTime: Option[Date] = scala
      .Option(impl.configRuleInvokedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val annotation: Option[StringWithCharLimit256] = scala
      .Option(impl.annotation())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val resultToken: Option[String] =
      scala.Option(impl.resultToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.EvaluationResult
  ): zio.aws.config.model.EvaluationResult.ReadOnly = new Wrapper(impl)
}
