package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDeliveryChannelsResponse(
    deliveryChannels: Option[Iterable[zio.aws.config.model.DeliveryChannel]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse = {
    import DescribeDeliveryChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse
      .builder()
      .optionallyWith(
        deliveryChannels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deliveryChannels)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeDeliveryChannelsResponse.ReadOnly =
    zio.aws.config.model.DescribeDeliveryChannelsResponse.wrap(buildAwsValue())
}
object DescribeDeliveryChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeDeliveryChannelsResponse =
      zio.aws.config.model.DescribeDeliveryChannelsResponse(
        deliveryChannels.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deliveryChannels
        : Option[List[zio.aws.config.model.DeliveryChannel.ReadOnly]]
    def getDeliveryChannels: ZIO[Any, AwsError, List[
      zio.aws.config.model.DeliveryChannel.ReadOnly
    ]] = AwsError.unwrapOptionField("deliveryChannels", deliveryChannels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse
  ) extends zio.aws.config.model.DescribeDeliveryChannelsResponse.ReadOnly {
    override val deliveryChannels
        : Option[List[zio.aws.config.model.DeliveryChannel.ReadOnly]] = scala
      .Option(impl.deliveryChannels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.DeliveryChannel.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse
  ): zio.aws.config.model.DescribeDeliveryChannelsResponse.ReadOnly =
    new Wrapper(impl)
}
