package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationAggregatorSourcesStatusResponse(
    aggregatedSourceStatusList: Option[
      Iterable[zio.aws.config.model.AggregatedSourceStatus]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse = {
    import DescribeConfigurationAggregatorSourcesStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse
      .builder()
      .optionallyWith(
        aggregatedSourceStatusList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregatedSourceStatusList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse.ReadOnly =
    zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse
      .wrap(buildAwsValue())
}
object DescribeConfigurationAggregatorSourcesStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse =
      zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse(
        aggregatedSourceStatusList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def aggregatedSourceStatusList
        : Option[List[zio.aws.config.model.AggregatedSourceStatus.ReadOnly]]
    def nextToken: Option[String]
    def getAggregatedSourceStatusList: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregatedSourceStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "aggregatedSourceStatusList",
      aggregatedSourceStatusList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse
  ) extends zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse.ReadOnly {
    override val aggregatedSourceStatusList
        : Option[List[zio.aws.config.model.AggregatedSourceStatus.ReadOnly]] =
      scala
        .Option(impl.aggregatedSourceStatusList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.AggregatedSourceStatus.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse
  ): zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse.ReadOnly =
    new Wrapper(impl)
}
