package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteRemediationExceptionsResponse(
    failedBatches: Option[
      Iterable[zio.aws.config.model.FailedDeleteRemediationExceptionsBatch]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse = {
    import DeleteRemediationExceptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse
      .builder()
      .optionallyWith(
        failedBatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedBatches)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DeleteRemediationExceptionsResponse.ReadOnly =
    zio.aws.config.model.DeleteRemediationExceptionsResponse
      .wrap(buildAwsValue())
}
object DeleteRemediationExceptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteRemediationExceptionsResponse =
      zio.aws.config.model.DeleteRemediationExceptionsResponse(
        failedBatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedBatches: Option[
      List[zio.aws.config.model.FailedDeleteRemediationExceptionsBatch.ReadOnly]
    ]
    def getFailedBatches: ZIO[Any, AwsError, List[
      zio.aws.config.model.FailedDeleteRemediationExceptionsBatch.ReadOnly
    ]] = AwsError.unwrapOptionField("failedBatches", failedBatches)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse
  ) extends zio.aws.config.model.DeleteRemediationExceptionsResponse.ReadOnly {
    override val failedBatches: Option[
      List[zio.aws.config.model.FailedDeleteRemediationExceptionsBatch.ReadOnly]
    ] = scala
      .Option(impl.failedBatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.FailedDeleteRemediationExceptionsBatch.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse
  ): zio.aws.config.model.DeleteRemediationExceptionsResponse.ReadOnly =
    new Wrapper(impl)
}
