package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConfigSnapshotDeliveryProperties(
    deliveryFrequency: Option[zio.aws.config.model.MaximumExecutionFrequency] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigSnapshotDeliveryProperties = {
    import ConfigSnapshotDeliveryProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigSnapshotDeliveryProperties
      .builder()
      .optionallyWith(deliveryFrequency.map(value => value.unwrap))(
        _.deliveryFrequency
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ConfigSnapshotDeliveryProperties.ReadOnly =
    zio.aws.config.model.ConfigSnapshotDeliveryProperties.wrap(buildAwsValue())
}
object ConfigSnapshotDeliveryProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigSnapshotDeliveryProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigSnapshotDeliveryProperties =
      zio.aws.config.model
        .ConfigSnapshotDeliveryProperties(deliveryFrequency.map(value => value))
    def deliveryFrequency
        : Option[zio.aws.config.model.MaximumExecutionFrequency]
    def getDeliveryFrequency
        : ZIO[Any, AwsError, zio.aws.config.model.MaximumExecutionFrequency] =
      AwsError.unwrapOptionField("deliveryFrequency", deliveryFrequency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigSnapshotDeliveryProperties
  ) extends zio.aws.config.model.ConfigSnapshotDeliveryProperties.ReadOnly {
    override val deliveryFrequency
        : Option[zio.aws.config.model.MaximumExecutionFrequency] = scala
      .Option(impl.deliveryFrequency())
      .map(value => zio.aws.config.model.MaximumExecutionFrequency.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigSnapshotDeliveryProperties
  ): zio.aws.config.model.ConfigSnapshotDeliveryProperties.ReadOnly =
    new Wrapper(impl)
}
