package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{AwsRegion, AccountId}
import scala.jdk.CollectionConverters.*
final case class ResourceCountFilters(
    resourceType: Option[zio.aws.config.model.ResourceType] = None,
    accountId: Option[AccountId] = None,
    region: Option[AwsRegion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceCountFilters = {
    import ResourceCountFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceCountFilters
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        region.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceCountFilters.ReadOnly =
    zio.aws.config.model.ResourceCountFilters.wrap(buildAwsValue())
}
object ResourceCountFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceCountFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceCountFilters =
      zio.aws.config.model.ResourceCountFilters(
        resourceType.map(value => value),
        accountId.map(value => value),
        region.map(value => value)
      )
    def resourceType: Option[zio.aws.config.model.ResourceType]
    def accountId: Option[AccountId]
    def region: Option[AwsRegion]
    def getResourceType: ZIO[Any, AwsError, zio.aws.config.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceCountFilters
  ) extends zio.aws.config.model.ResourceCountFilters.ReadOnly {
    override val resourceType: Option[zio.aws.config.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.config.model.ResourceType.wrap(value))
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val region: Option[AwsRegion] = scala
      .Option(impl.region())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceCountFilters
  ): zio.aws.config.model.ResourceCountFilters.ReadOnly = new Wrapper(impl)
}
