package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.QueryArn
import scala.jdk.CollectionConverters.*
final case class PutStoredQueryResponse(queryArn: Option[QueryArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutStoredQueryResponse = {
    import PutStoredQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutStoredQueryResponse
      .builder()
      .optionallyWith(
        queryArn.map(value => QueryArn.unwrap(value): java.lang.String)
      )(_.queryArn)
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutStoredQueryResponse.ReadOnly =
    zio.aws.config.model.PutStoredQueryResponse.wrap(buildAwsValue())
}
object PutStoredQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutStoredQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutStoredQueryResponse =
      zio.aws.config.model.PutStoredQueryResponse(queryArn.map(value => value))
    def queryArn: Option[QueryArn]
    def getQueryArn: ZIO[Any, AwsError, QueryArn] =
      AwsError.unwrapOptionField("queryArn", queryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutStoredQueryResponse
  ) extends zio.aws.config.model.PutStoredQueryResponse.ReadOnly {
    override val queryArn: Option[QueryArn] = scala
      .Option(impl.queryArn())
      .map(value => zio.aws.config.model.primitives.QueryArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutStoredQueryResponse
  ): zio.aws.config.model.PutStoredQueryResponse.ReadOnly = new Wrapper(impl)
}
