package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutStoredQueryRequest(
    storedQuery: zio.aws.config.model.StoredQuery,
    tags: Option[Iterable[zio.aws.config.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutStoredQueryRequest = {
    import PutStoredQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutStoredQueryRequest
      .builder()
      .storedQuery(storedQuery.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutStoredQueryRequest.ReadOnly =
    zio.aws.config.model.PutStoredQueryRequest.wrap(buildAwsValue())
}
object PutStoredQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutStoredQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutStoredQueryRequest =
      zio.aws.config.model.PutStoredQueryRequest(
        storedQuery.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storedQuery: zio.aws.config.model.StoredQuery.ReadOnly
    def tags: Option[List[zio.aws.config.model.Tag.ReadOnly]]
    def getStoredQuery
        : ZIO[Any, Nothing, zio.aws.config.model.StoredQuery.ReadOnly] =
      ZIO.succeed(storedQuery)
    def getTags: ZIO[Any, AwsError, List[zio.aws.config.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutStoredQueryRequest
  ) extends zio.aws.config.model.PutStoredQueryRequest.ReadOnly {
    override val storedQuery: zio.aws.config.model.StoredQuery.ReadOnly =
      zio.aws.config.model.StoredQuery.wrap(impl.storedQuery())
    override val tags: Option[List[zio.aws.config.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutStoredQueryRequest
  ): zio.aws.config.model.PutStoredQueryRequest.ReadOnly = new Wrapper(impl)
}
