package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutEvaluationsResponse(
    failedEvaluations: Option[Iterable[zio.aws.config.model.Evaluation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutEvaluationsResponse = {
    import PutEvaluationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutEvaluationsResponse
      .builder()
      .optionallyWith(
        failedEvaluations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedEvaluations)
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutEvaluationsResponse.ReadOnly =
    zio.aws.config.model.PutEvaluationsResponse.wrap(buildAwsValue())
}
object PutEvaluationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutEvaluationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutEvaluationsResponse =
      zio.aws.config.model.PutEvaluationsResponse(
        failedEvaluations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedEvaluations
        : Option[List[zio.aws.config.model.Evaluation.ReadOnly]]
    def getFailedEvaluations
        : ZIO[Any, AwsError, List[zio.aws.config.model.Evaluation.ReadOnly]] =
      AwsError.unwrapOptionField("failedEvaluations", failedEvaluations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutEvaluationsResponse
  ) extends zio.aws.config.model.PutEvaluationsResponse.ReadOnly {
    override val failedEvaluations
        : Option[List[zio.aws.config.model.Evaluation.ReadOnly]] = scala
      .Option(impl.failedEvaluations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.Evaluation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutEvaluationsResponse
  ): zio.aws.config.model.PutEvaluationsResponse.ReadOnly = new Wrapper(impl)
}
